package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SafeDerivedInit.SafeInitIface}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSafeInitIface.builder()}.
 */
@Generated(from = "SafeDerivedInit.SafeInitIface", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSafeInitIface implements SafeDerivedInit.SafeInitIface {
  private final int b;
  private final int a;
  private final int c;

  private ImmutableSafeInitIface(ImmutableSafeInitIface.Builder builder) {
    if (builder.bIsSet()) {
      initShim.b(builder.b);
    }
    if (builder.aIsSet()) {
      initShim.a(builder.a);
    }
    if (builder.cIsSet()) {
      initShim.c(builder.c);
    }
    this.b = initShim.b();
    this.a = initShim.a();
    this.c = initShim.c();
    this.initShim = null;
  }

  private ImmutableSafeInitIface(int b, int a, int c) {
    this.b = b;
    this.a = a;
    this.c = c;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "SafeDerivedInit.SafeInitIface", generator = "Immutables")
  private final class InitShim {
    private byte bBuildStage = STAGE_UNINITIALIZED;
    private int b;

    int b() {
      if (bBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bBuildStage == STAGE_UNINITIALIZED) {
        bBuildStage = STAGE_INITIALIZING;
        this.b = bInitialize();
        bBuildStage = STAGE_INITIALIZED;
      }
      return this.b;
    }

    void b(int b) {
      this.b = b;
      bBuildStage = STAGE_INITIALIZED;
    }

    private byte aBuildStage = STAGE_UNINITIALIZED;
    private int a;

    int a() {
      if (aBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (aBuildStage == STAGE_UNINITIALIZED) {
        aBuildStage = STAGE_INITIALIZING;
        this.a = aInitialize();
        aBuildStage = STAGE_INITIALIZED;
      }
      return this.a;
    }

    void a(int a) {
      this.a = a;
      aBuildStage = STAGE_INITIALIZED;
    }

    private byte cBuildStage = STAGE_UNINITIALIZED;
    private int c;

    int c() {
      if (cBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cBuildStage == STAGE_UNINITIALIZED) {
        cBuildStage = STAGE_INITIALIZING;
        this.c = cInitialize();
        cBuildStage = STAGE_INITIALIZED;
      }
      return this.c;
    }

    void c(int c) {
      this.c = c;
      cBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (bBuildStage == STAGE_INITIALIZING) attributes.add("b");
      if (aBuildStage == STAGE_INITIALIZING) attributes.add("a");
      if (cBuildStage == STAGE_INITIALIZING) attributes.add("c");
      return "Cannot build SafeInitIface, attribute initializers form cycle " + attributes;
    }
  }

  private int bInitialize() {
    return SafeDerivedInit.SafeInitIface.super.b();
  }

  private int aInitialize() {
    return SafeDerivedInit.SafeInitIface.super.a();
  }

  private int cInitialize() {
    return SafeDerivedInit.SafeInitIface.super.c();
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public int b() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.b()
        : this.b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.a()
        : this.a;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public int c() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.c()
        : this.c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SafeDerivedInit.SafeInitIface#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSafeInitIface withB(int value) {
    if (this.b == value) return this;
    return new ImmutableSafeInitIface(value, this.a, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SafeDerivedInit.SafeInitIface#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSafeInitIface withA(int value) {
    if (this.a == value) return this;
    return new ImmutableSafeInitIface(this.b, value, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SafeDerivedInit.SafeInitIface#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSafeInitIface withC(int value) {
    if (this.c == value) return this;
    return new ImmutableSafeInitIface(this.b, this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSafeInitIface} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSafeInitIface
        && equalTo(0, (ImmutableSafeInitIface) another);
  }

  private boolean equalTo(int synthetic, ImmutableSafeInitIface another) {
    return b == another.b
        && a == another.a
        && c == another.c;
  }

  /**
   * Computes a hash code from attributes: {@code b}, {@code a}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + b;
    h += (h << 5) + a;
    h += (h << 5) + c;
    return h;
  }

  /**
   * Prints the immutable value {@code SafeInitIface} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SafeInitIface")
        .omitNullValues()
        .add("b", b)
        .add("a", a)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SafeDerivedInit.SafeInitIface} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SafeInitIface instance
   */
  public static ImmutableSafeInitIface copyOf(SafeDerivedInit.SafeInitIface instance) {
    if (instance instanceof ImmutableSafeInitIface) {
      return (ImmutableSafeInitIface) instance;
    }
    return ImmutableSafeInitIface.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSafeInitIface ImmutableSafeInitIface}.
   * <pre>
   * ImmutableSafeInitIface.builder()
   *    .b(int) // optional {@link SafeDerivedInit.SafeInitIface#b() b}
   *    .a(int) // optional {@link SafeDerivedInit.SafeInitIface#a() a}
   *    .c(int) // optional {@link SafeDerivedInit.SafeInitIface#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableSafeInitIface builder
   */
  public static ImmutableSafeInitIface.Builder builder() {
    return new ImmutableSafeInitIface.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSafeInitIface ImmutableSafeInitIface}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SafeDerivedInit.SafeInitIface", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_B = 0x1L;
    private static final long OPT_BIT_A = 0x2L;
    private static final long OPT_BIT_C = 0x4L;
    private long optBits;

    private int b;
    private int a;
    private int c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SafeInitIface} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SafeDerivedInit.SafeInitIface instance) {
      Objects.requireNonNull(instance, "instance");
      b(instance.b());
      a(instance.a());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link SafeDerivedInit.SafeInitIface#b() b} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SafeDerivedInit.SafeInitIface#b() b}.</em>
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      optBits |= OPT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link SafeDerivedInit.SafeInitIface#a() a} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SafeDerivedInit.SafeInitIface#a() a}.</em>
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      optBits |= OPT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link SafeDerivedInit.SafeInitIface#c() c} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SafeDerivedInit.SafeInitIface#c() c}.</em>
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(int c) {
      this.c = c;
      optBits |= OPT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSafeInitIface ImmutableSafeInitIface}.
     * @return An immutable instance of SafeInitIface
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSafeInitIface build() {
      return new ImmutableSafeInitIface(this);
    }

    private boolean bIsSet() {
      return (optBits & OPT_BIT_B) != 0;
    }

    private boolean aIsSet() {
      return (optBits & OPT_BIT_A) != 0;
    }

    private boolean cIsSet() {
      return (optBits & OPT_BIT_C) != 0;
    }
  }
}
