package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Redacted.RedactedMaskJdkOnly}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRedactedMaskJdkOnly.builder()}.
 */
@Generated(from = "Redacted.RedactedMaskJdkOnly", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRedactedMaskJdkOnly implements Redacted.RedactedMaskJdkOnly {
  private final int code;

  private ImmutableRedactedMaskJdkOnly(int code) {
    this.code = code;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @Override
  public int code() {
    return code;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Redacted.RedactedMaskJdkOnly#code() code} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedactedMaskJdkOnly withCode(int value) {
    if (this.code == value) return this;
    return new ImmutableRedactedMaskJdkOnly(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRedactedMaskJdkOnly} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRedactedMaskJdkOnly
        && equalTo(0, (ImmutableRedactedMaskJdkOnly) another);
  }

  private boolean equalTo(int synthetic, ImmutableRedactedMaskJdkOnly another) {
    return code == another.code;
  }

  /**
   * Computes a hash code from attributes: {@code code}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + code;
    return h;
  }

  /**
   * Prints the immutable value {@code RedactedMaskJdkOnly} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RedactedMaskJdkOnly{"
        + "code=" + "$$$$"
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Redacted.RedactedMaskJdkOnly} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RedactedMaskJdkOnly instance
   */
  public static ImmutableRedactedMaskJdkOnly copyOf(Redacted.RedactedMaskJdkOnly instance) {
    if (instance instanceof ImmutableRedactedMaskJdkOnly) {
      return (ImmutableRedactedMaskJdkOnly) instance;
    }
    return ImmutableRedactedMaskJdkOnly.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRedactedMaskJdkOnly ImmutableRedactedMaskJdkOnly}.
   * <pre>
   * ImmutableRedactedMaskJdkOnly.builder()
   *    .code(int) // required {@link Redacted.RedactedMaskJdkOnly#code() code}
   *    .build();
   * </pre>
   * @return A new ImmutableRedactedMaskJdkOnly builder
   */
  public static ImmutableRedactedMaskJdkOnly.Builder builder() {
    return new ImmutableRedactedMaskJdkOnly.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRedactedMaskJdkOnly ImmutableRedactedMaskJdkOnly}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Redacted.RedactedMaskJdkOnly", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CODE = 0x1L;
    private long initBits = 0x1L;

    private int code;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RedactedMaskJdkOnly} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Redacted.RedactedMaskJdkOnly instance) {
      Objects.requireNonNull(instance, "instance");
      code(instance.code());
      return this;
    }

    /**
     * Initializes the value for the {@link Redacted.RedactedMaskJdkOnly#code() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder code(int code) {
      this.code = code;
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRedactedMaskJdkOnly ImmutableRedactedMaskJdkOnly}.
     * @return An immutable instance of RedactedMaskJdkOnly
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRedactedMaskJdkOnly build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRedactedMaskJdkOnly(code);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      return "Cannot build RedactedMaskJdkOnly, some of required attributes are not set " + attributes;
    }
  }
}
