package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProtectedNoargConstructorNominal}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProtectedNoargConstructorNominal.builder()}.
 */
@Generated(from = "ProtectedNoargConstructorNominal", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableProtectedNoargConstructorNominal
    implements ProtectedNoargConstructorNominal {
  private final boolean is;
  private final byte b;
  private final short s;
  private final int i;
  private final long l;
  private final char c;
  private final float f;
  private final double d;
  private final Object o;
  private final String z;

  protected ImmutableProtectedNoargConstructorNominal() {
    this.is = false;
    this.b = 0;
    this.s = 0;
    this.i = 0;
    this.l = 0;
    this.c = 0;
    this.f = 0;
    this.d = 0;
    this.o = null;
    this.z = null;
  }

  private ImmutableProtectedNoargConstructorNominal(
      boolean is,
      byte b,
      short s,
      int i,
      long l,
      char c,
      float f,
      double d,
      Object o,
      String z) {
    this.is = is;
    this.b = b;
    this.s = s;
    this.i = i;
    this.l = l;
    this.c = c;
    this.f = f;
    this.d = d;
    this.o = o;
    this.z = z;
  }

  /**
   * @return The value of the {@code is} attribute
   */
  @Override
  public boolean is() {
    return is;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public byte b() {
    return b;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public short s() {
    return s;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  public int i() {
    return i;
  }

  /**
   * @return The value of the {@code l} attribute
   */
  @Override
  public long l() {
    return l;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public char c() {
    return c;
  }

  /**
   * @return The value of the {@code f} attribute
   */
  @Override
  public float f() {
    return f;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public double d() {
    return d;
  }

  /**
   * @return The value of the {@code o} attribute
   */
  @Override
  public Object o() {
    return o;
  }

  /**
   * @return The value of the {@code z} attribute
   */
  @Override
  public String z() {
    return z;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#is() is} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for is
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withIs(boolean value) {
    if (this.is == value) return this;
    return new ImmutableProtectedNoargConstructorNominal(value, this.b, this.s, this.i, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withB(byte value) {
    if (this.b == value) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, value, this.s, this.i, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#s() s} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withS(short value) {
    if (this.s == value) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, value, this.i, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#i() i} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withI(int value) {
    if (this.i == value) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, this.s, value, this.l, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#l() l} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for l
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withL(long value) {
    if (this.l == value) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, this.s, this.i, value, this.c, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withC(char value) {
    if (this.c == value) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, this.s, this.i, this.l, value, this.f, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#f() f} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for f
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withF(float value) {
    if (Float.floatToIntBits(this.f) == Float.floatToIntBits(value)) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, this.s, this.i, this.l, this.c, value, this.d, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#d() d} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withD(double value) {
    if (Double.doubleToLongBits(this.d) == Double.doubleToLongBits(value)) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, this.s, this.i, this.l, this.c, this.f, value, this.o, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#o() o} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for o
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withO(Object value) {
    if (this.o == value) return this;
    Object newValue = Objects.requireNonNull(value, "o");
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, this.s, this.i, this.l, this.c, this.f, this.d, newValue, this.z);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProtectedNoargConstructorNominal#z() z} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for z
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProtectedNoargConstructorNominal withZ(String value) {
    String newValue = Objects.requireNonNull(value, "z");
    if (Objects.equals(this.z, newValue)) return this;
    return new ImmutableProtectedNoargConstructorNominal(this.is, this.b, this.s, this.i, this.l, this.c, this.f, this.d, this.o, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProtectedNoargConstructorNominal} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProtectedNoargConstructorNominal
        && equalTo(0, (ImmutableProtectedNoargConstructorNominal) another);
  }

  private boolean equalTo(int synthetic, ImmutableProtectedNoargConstructorNominal another) {
    return is == another.is
        && b == another.b
        && s == another.s
        && i == another.i
        && l == another.l
        && c == another.c
        && Float.floatToIntBits(f) == Float.floatToIntBits(another.f)
        && Double.doubleToLongBits(d) == Double.doubleToLongBits(another.d)
        && o.equals(another.o)
        && z.equals(another.z);
  }

  /**
   * Computes a hash code from attributes: {@code is}, {@code b}, {@code s}, {@code i}, {@code l}, {@code c}, {@code f}, {@code d}, {@code o}, {@code z}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(is);
    h += (h << 5) + Bytes.hashCode(b);
    h += (h << 5) + Shorts.hashCode(s);
    h += (h << 5) + i;
    h += (h << 5) + Longs.hashCode(l);
    h += (h << 5) + Chars.hashCode(c);
    h += (h << 5) + Floats.hashCode(f);
    h += (h << 5) + Doubles.hashCode(d);
    h += (h << 5) + o.hashCode();
    h += (h << 5) + z.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProtectedNoargConstructorNominal} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProtectedNoargConstructorNominal")
        .omitNullValues()
        .add("is", is)
        .add("b", b)
        .add("s", s)
        .add("i", i)
        .add("l", l)
        .add("c", c)
        .add("f", f)
        .add("d", d)
        .add("o", o)
        .add("z", z)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ProtectedNoargConstructorNominal} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProtectedNoargConstructorNominal instance
   */
  public static ImmutableProtectedNoargConstructorNominal copyOf(ProtectedNoargConstructorNominal instance) {
    if (instance instanceof ImmutableProtectedNoargConstructorNominal) {
      return (ImmutableProtectedNoargConstructorNominal) instance;
    }
    return ImmutableProtectedNoargConstructorNominal.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProtectedNoargConstructorNominal ImmutableProtectedNoargConstructorNominal}.
   * <pre>
   * ImmutableProtectedNoargConstructorNominal.builder()
   *    .is(boolean) // required {@link ProtectedNoargConstructorNominal#is() is}
   *    .b(byte) // required {@link ProtectedNoargConstructorNominal#b() b}
   *    .s(short) // required {@link ProtectedNoargConstructorNominal#s() s}
   *    .i(int) // required {@link ProtectedNoargConstructorNominal#i() i}
   *    .l(long) // required {@link ProtectedNoargConstructorNominal#l() l}
   *    .c(char) // required {@link ProtectedNoargConstructorNominal#c() c}
   *    .f(float) // required {@link ProtectedNoargConstructorNominal#f() f}
   *    .d(double) // required {@link ProtectedNoargConstructorNominal#d() d}
   *    .o(Object) // required {@link ProtectedNoargConstructorNominal#o() o}
   *    .z(String) // required {@link ProtectedNoargConstructorNominal#z() z}
   *    .build();
   * </pre>
   * @return A new ImmutableProtectedNoargConstructorNominal builder
   */
  public static ImmutableProtectedNoargConstructorNominal.Builder builder() {
    return new ImmutableProtectedNoargConstructorNominal.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProtectedNoargConstructorNominal ImmutableProtectedNoargConstructorNominal}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProtectedNoargConstructorNominal", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IS = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_S = 0x4L;
    private static final long INIT_BIT_I = 0x8L;
    private static final long INIT_BIT_L = 0x10L;
    private static final long INIT_BIT_C = 0x20L;
    private static final long INIT_BIT_F = 0x40L;
    private static final long INIT_BIT_D = 0x80L;
    private static final long INIT_BIT_O = 0x100L;
    private static final long INIT_BIT_Z = 0x200L;
    private long initBits = 0x3ffL;

    private boolean is;
    private byte b;
    private short s;
    private int i;
    private long l;
    private char c;
    private float f;
    private double d;
    private @Nullable Object o;
    private @Nullable String z;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProtectedNoargConstructorNominal} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ProtectedNoargConstructorNominal instance) {
      Objects.requireNonNull(instance, "instance");
      is(instance.is());
      b(instance.b());
      s(instance.s());
      i(instance.i());
      l(instance.l());
      c(instance.c());
      f(instance.f());
      d(instance.d());
      o(instance.o());
      z(instance.z());
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#is() is} attribute.
     * @param is The value for is 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder is(boolean is) {
      this.is = is;
      initBits &= ~INIT_BIT_IS;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(byte b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#s() s} attribute.
     * @param s The value for s 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(short s) {
      this.s = s;
      initBits &= ~INIT_BIT_S;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#i() i} attribute.
     * @param i The value for i 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i(int i) {
      this.i = i;
      initBits &= ~INIT_BIT_I;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#l() l} attribute.
     * @param l The value for l 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l(long l) {
      this.l = l;
      initBits &= ~INIT_BIT_L;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(char c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#f() f} attribute.
     * @param f The value for f 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder f(float f) {
      this.f = f;
      initBits &= ~INIT_BIT_F;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(double d) {
      this.d = d;
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#o() o} attribute.
     * @param o The value for o 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder o(Object o) {
      this.o = Objects.requireNonNull(o, "o");
      initBits &= ~INIT_BIT_O;
      return this;
    }

    /**
     * Initializes the value for the {@link ProtectedNoargConstructorNominal#z() z} attribute.
     * @param z The value for z 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder z(String z) {
      this.z = Objects.requireNonNull(z, "z");
      initBits &= ~INIT_BIT_Z;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProtectedNoargConstructorNominal ImmutableProtectedNoargConstructorNominal}.
     * @return An immutable instance of ProtectedNoargConstructorNominal
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProtectedNoargConstructorNominal build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProtectedNoargConstructorNominal(is, b, s, i, l, c, f, d, o, z);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IS) != 0) attributes.add("is");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_S) != 0) attributes.add("s");
      if ((initBits & INIT_BIT_I) != 0) attributes.add("i");
      if ((initBits & INIT_BIT_L) != 0) attributes.add("l");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      if ((initBits & INIT_BIT_F) != 0) attributes.add("f");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      if ((initBits & INIT_BIT_O) != 0) attributes.add("o");
      if ((initBits & INIT_BIT_Z) != 0) attributes.add("z");
      return "Cannot build ProtectedNoargConstructorNominal, some of required attributes are not set " + attributes;
    }
  }
}
