package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrivateNoargConstructorIsOverriddenBySingleton}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrivateNoargConstructorIsOverriddenBySingleton.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutablePrivateNoargConstructorIsOverriddenBySingleton.of()}.
 */
@Generated(from = "PrivateNoargConstructorIsOverriddenBySingleton", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutablePrivateNoargConstructorIsOverriddenBySingleton
    implements PrivateNoargConstructorIsOverriddenBySingleton {
  private final int test;

  private ImmutablePrivateNoargConstructorIsOverriddenBySingleton() {
    this.test = PrivateNoargConstructorIsOverriddenBySingleton.super.test();
  }

  private ImmutablePrivateNoargConstructorIsOverriddenBySingleton(ImmutablePrivateNoargConstructorIsOverriddenBySingleton.Builder builder) {
    this.test = builder.testIsSet()
        ? builder.test
        : PrivateNoargConstructorIsOverriddenBySingleton.super.test();
  }

  private ImmutablePrivateNoargConstructorIsOverriddenBySingleton(int test) {
    this.test = test;
  }

  /**
   * @return The value of the {@code test} attribute
   */
  @Override
  public int test() {
    return test;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrivateNoargConstructorIsOverriddenBySingleton#test() test} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for test
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrivateNoargConstructorIsOverriddenBySingleton withTest(int value) {
    if (this.test == value) return this;
    return validate(new ImmutablePrivateNoargConstructorIsOverriddenBySingleton(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrivateNoargConstructorIsOverriddenBySingleton} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrivateNoargConstructorIsOverriddenBySingleton
        && equalTo(0, (ImmutablePrivateNoargConstructorIsOverriddenBySingleton) another);
  }

  private boolean equalTo(int synthetic, ImmutablePrivateNoargConstructorIsOverriddenBySingleton another) {
    return test == another.test;
  }

  /**
   * Computes a hash code from attributes: {@code test}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + test;
    return h;
  }

  /**
   * Prints the immutable value {@code PrivateNoargConstructorIsOverriddenBySingleton} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PrivateNoargConstructorIsOverriddenBySingleton")
        .omitNullValues()
        .add("test", test)
        .toString();
  }

  private static final ImmutablePrivateNoargConstructorIsOverriddenBySingleton INSTANCE = validate(new ImmutablePrivateNoargConstructorIsOverriddenBySingleton());

  /**
   * Returns the default immutable singleton value of {@code PrivateNoargConstructorIsOverriddenBySingleton}
   * @return An immutable instance of PrivateNoargConstructorIsOverriddenBySingleton
   */
  public static ImmutablePrivateNoargConstructorIsOverriddenBySingleton of() {
    return INSTANCE;
  }

  private static ImmutablePrivateNoargConstructorIsOverriddenBySingleton validate(ImmutablePrivateNoargConstructorIsOverriddenBySingleton instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link PrivateNoargConstructorIsOverriddenBySingleton} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrivateNoargConstructorIsOverriddenBySingleton instance
   */
  public static ImmutablePrivateNoargConstructorIsOverriddenBySingleton copyOf(PrivateNoargConstructorIsOverriddenBySingleton instance) {
    if (instance instanceof ImmutablePrivateNoargConstructorIsOverriddenBySingleton) {
      return (ImmutablePrivateNoargConstructorIsOverriddenBySingleton) instance;
    }
    return ImmutablePrivateNoargConstructorIsOverriddenBySingleton.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrivateNoargConstructorIsOverriddenBySingleton ImmutablePrivateNoargConstructorIsOverriddenBySingleton}.
   * <pre>
   * ImmutablePrivateNoargConstructorIsOverriddenBySingleton.builder()
   *    .test(int) // optional {@link PrivateNoargConstructorIsOverriddenBySingleton#test() test}
   *    .build();
   * </pre>
   * @return A new ImmutablePrivateNoargConstructorIsOverriddenBySingleton builder
   */
  public static ImmutablePrivateNoargConstructorIsOverriddenBySingleton.Builder builder() {
    return new ImmutablePrivateNoargConstructorIsOverriddenBySingleton.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrivateNoargConstructorIsOverriddenBySingleton ImmutablePrivateNoargConstructorIsOverriddenBySingleton}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrivateNoargConstructorIsOverriddenBySingleton", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_TEST = 0x1L;
    private long optBits;

    private int test;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrivateNoargConstructorIsOverriddenBySingleton} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PrivateNoargConstructorIsOverriddenBySingleton instance) {
      Objects.requireNonNull(instance, "instance");
      test(instance.test());
      return this;
    }

    /**
     * Initializes the value for the {@link PrivateNoargConstructorIsOverriddenBySingleton#test() test} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PrivateNoargConstructorIsOverriddenBySingleton#test() test}.</em>
     * @param test The value for test 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder test(int test) {
      this.test = test;
      optBits |= OPT_BIT_TEST;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrivateNoargConstructorIsOverriddenBySingleton ImmutablePrivateNoargConstructorIsOverriddenBySingleton}.
     * @return An immutable instance of PrivateNoargConstructorIsOverriddenBySingleton
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrivateNoargConstructorIsOverriddenBySingleton build() {
      return ImmutablePrivateNoargConstructorIsOverriddenBySingleton.validate(new ImmutablePrivateNoargConstructorIsOverriddenBySingleton(this));
    }

    private boolean testIsSet() {
      return (optBits & OPT_BIT_TEST) != 0;
    }
  }
}
