package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LazyHash}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLazyHash.builder()}.
 */
@Generated(from = "LazyHash", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLazyHash implements LazyHash {
  private final String s;
  private final boolean b;
  private final int i;
  @SuppressWarnings("Immutable")
  private transient int hashCode; // hashCode lazily computed

  private ImmutableLazyHash(String s, boolean b, int i) {
    this.s = s;
    this.b = b;
    this.i = i;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public String s() {
    return s;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public boolean b() {
    return b;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  public int i() {
    return i;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LazyHash#s() s} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLazyHash withS(String value) {
    String newValue = Objects.requireNonNull(value, "s");
    if (this.s.equals(newValue)) return this;
    return new ImmutableLazyHash(newValue, this.b, this.i);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LazyHash#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLazyHash withB(boolean value) {
    if (this.b == value) return this;
    return new ImmutableLazyHash(this.s, value, this.i);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LazyHash#i() i} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLazyHash withI(int value) {
    if (this.i == value) return this;
    return new ImmutableLazyHash(this.s, this.b, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLazyHash} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLazyHash
        && equalTo(0, (ImmutableLazyHash) another);
  }

  private boolean equalTo(int synthetic, ImmutableLazyHash another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return s.equals(another.s)
        && b == another.b
        && i == another.i;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code s}, {@code b}, {@code i}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + s.hashCode();
    h += (h << 5) + Booleans.hashCode(b);
    h += (h << 5) + i;
    return h;
  }

  /**
   * Prints the immutable value {@code LazyHash} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LazyHash")
        .omitNullValues()
        .add("s", s)
        .add("b", b)
        .add("i", i)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link LazyHash} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LazyHash instance
   */
  public static ImmutableLazyHash copyOf(LazyHash instance) {
    if (instance instanceof ImmutableLazyHash) {
      return (ImmutableLazyHash) instance;
    }
    return ImmutableLazyHash.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLazyHash ImmutableLazyHash}.
   * <pre>
   * ImmutableLazyHash.builder()
   *    .s(String) // required {@link LazyHash#s() s}
   *    .b(boolean) // required {@link LazyHash#b() b}
   *    .i(int) // required {@link LazyHash#i() i}
   *    .build();
   * </pre>
   * @return A new ImmutableLazyHash builder
   */
  public static ImmutableLazyHash.Builder builder() {
    return new ImmutableLazyHash.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLazyHash ImmutableLazyHash}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LazyHash", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_S = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_I = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String s;
    private boolean b;
    private int i;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LazyHash} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LazyHash instance) {
      Objects.requireNonNull(instance, "instance");
      s(instance.s());
      b(instance.b());
      i(instance.i());
      return this;
    }

    /**
     * Initializes the value for the {@link LazyHash#s() s} attribute.
     * @param s The value for s 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(String s) {
      this.s = Objects.requireNonNull(s, "s");
      initBits &= ~INIT_BIT_S;
      return this;
    }

    /**
     * Initializes the value for the {@link LazyHash#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(boolean b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link LazyHash#i() i} attribute.
     * @param i The value for i 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i(int i) {
      this.i = i;
      initBits &= ~INIT_BIT_I;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLazyHash ImmutableLazyHash}.
     * @return An immutable instance of LazyHash
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLazyHash build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLazyHash(s, b, i);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_S) != 0) attributes.add("s");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_I) != 0) attributes.add("i");
      return "Cannot build LazyHash, some of required attributes are not set " + attributes;
    }
  }
}
