package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JsonIgnore}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJsonIgnore.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableJsonIgnore.of()}.
 */
@Generated(from = "JsonIgnore", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJsonIgnore implements JsonIgnore {
  private final int value;
  private final ImmutableList<Integer> values;

  private ImmutableJsonIgnore(int value) {
    this.value = value;
    this.values = ImmutableList.of();
  }

  private ImmutableJsonIgnore(int value, ImmutableList<Integer> values) {
    this.value = value;
    this.values = values;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  public ImmutableList<Integer> values() {
    return values;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JsonIgnore#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJsonIgnore withValue(int value) {
    if (this.value == value) return this;
    return new ImmutableJsonIgnore(value, this.values);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JsonIgnore#values() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJsonIgnore withValues(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableJsonIgnore(this.value, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JsonIgnore#values() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJsonIgnore withValues(Iterable<Integer> elements) {
    if (this.values == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableJsonIgnore(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJsonIgnore} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJsonIgnore
        && equalTo(0, (ImmutableJsonIgnore) another);
  }

  private boolean equalTo(int synthetic, ImmutableJsonIgnore another) {
    return value == another.value
        && values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value;
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JsonIgnore} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JsonIgnore")
        .omitNullValues()
        .add("value", value)
        .add("values", values)
        .toString();
  }

  /**
   * Construct a new immutable {@code JsonIgnore} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable JsonIgnore instance
   */
  public static ImmutableJsonIgnore of(int value) {
    return new ImmutableJsonIgnore(value);
  }

  /**
   * Creates an immutable copy of a {@link JsonIgnore} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JsonIgnore instance
   */
  public static ImmutableJsonIgnore copyOf(JsonIgnore instance) {
    if (instance instanceof ImmutableJsonIgnore) {
      return (ImmutableJsonIgnore) instance;
    }
    return ImmutableJsonIgnore.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJsonIgnore ImmutableJsonIgnore}.
   * <pre>
   * ImmutableJsonIgnore.builder()
   *    .value(int) // required {@link JsonIgnore#value() value}
   *    .addValues|addAllValues(int) // {@link JsonIgnore#values() values} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJsonIgnore builder
   */
  public static ImmutableJsonIgnore.Builder builder() {
    return new ImmutableJsonIgnore.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJsonIgnore ImmutableJsonIgnore}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JsonIgnore", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private int value;
    private ImmutableList.Builder<Integer> values = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JsonIgnore} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JsonIgnore instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      addAllValues(instance.values());
      return this;
    }

    /**
     * Initializes the value for the {@link JsonIgnore#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link JsonIgnore#values() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(int element) {
      this.values.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JsonIgnore#values() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(int... elements) {
      this.values.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JsonIgnore#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder values(Iterable<Integer> elements) {
      this.values = ImmutableList.builder();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link JsonIgnore#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValues(Iterable<Integer> elements) {
      this.values.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableJsonIgnore ImmutableJsonIgnore}.
     * @return An immutable instance of JsonIgnore
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJsonIgnore build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJsonIgnore(value, values.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build JsonIgnore, some of required attributes are not set " + attributes;
    }
  }
}
