package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InternedClassWithSelfConstant}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInternedClassWithSelfConstant.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableInternedClassWithSelfConstant.of()}.
 */
@Generated(from = "InternedClassWithSelfConstant", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInternedClassWithSelfConstant
    extends InternedClassWithSelfConstant {
  private final String value;

  private ImmutableInternedClassWithSelfConstant(String value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableInternedClassWithSelfConstant(ImmutableInternedClassWithSelfConstant original, String value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InternedClassWithSelfConstant#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInternedClassWithSelfConstant withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return validate(new ImmutableInternedClassWithSelfConstant(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInternedClassWithSelfConstant} that have equal attribute values.
   * As instances of the {@code ImmutableInternedClassWithSelfConstant} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(int synthetic, ImmutableInternedClassWithSelfConstant another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InternedClassWithSelfConstant} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InternedClassWithSelfConstant")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  @Generated(from = "InternedClassWithSelfConstant", generator = "Immutables")
  private static class InternProxy {
    final ImmutableInternedClassWithSelfConstant instance;

    InternProxy(ImmutableInternedClassWithSelfConstant instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(0, ((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final class InternerHolder {
    static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();
  }

  /**
   * Construct a new immutable {@code InternedClassWithSelfConstant} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable InternedClassWithSelfConstant instance
   */
  public static ImmutableInternedClassWithSelfConstant of(String value) {
    return validate(new ImmutableInternedClassWithSelfConstant(value));
  }

  private static ImmutableInternedClassWithSelfConstant validate(ImmutableInternedClassWithSelfConstant instance) {
    return InternerHolder.INTERNER.intern(new InternProxy(instance)).instance;
  }

  /**
   * Creates an immutable copy of a {@link InternedClassWithSelfConstant} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InternedClassWithSelfConstant instance
   */
  public static ImmutableInternedClassWithSelfConstant copyOf(InternedClassWithSelfConstant instance) {
    if (instance instanceof ImmutableInternedClassWithSelfConstant) {
      return (ImmutableInternedClassWithSelfConstant) instance;
    }
    return ImmutableInternedClassWithSelfConstant.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInternedClassWithSelfConstant ImmutableInternedClassWithSelfConstant}.
   * <pre>
   * ImmutableInternedClassWithSelfConstant.builder()
   *    .value(String) // required {@link InternedClassWithSelfConstant#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableInternedClassWithSelfConstant builder
   */
  public static ImmutableInternedClassWithSelfConstant.Builder builder() {
    return new ImmutableInternedClassWithSelfConstant.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInternedClassWithSelfConstant ImmutableInternedClassWithSelfConstant}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InternedClassWithSelfConstant", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InternedClassWithSelfConstant} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InternedClassWithSelfConstant instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link InternedClassWithSelfConstant#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInternedClassWithSelfConstant ImmutableInternedClassWithSelfConstant}.
     * @return An immutable instance of InternedClassWithSelfConstant
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInternedClassWithSelfConstant build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableInternedClassWithSelfConstant.validate(new ImmutableInternedClassWithSelfConstant(null, value));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build InternedClassWithSelfConstant, some of required attributes are not set " + attributes;
    }
  }
}
