package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetterEncloser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetterEncloser.builder()}.
 */
@Generated(from = "GetterEncloser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetterEncloser implements GetterEncloser {
  private final Optional<Integer> optional;

  private ImmutableGetterEncloser(Optional<Integer> optional) {
    this.optional = optional;
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @Override
  public Optional<Integer> optional() {
    return optional;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GetterEncloser#optional() optional} attribute.
   * @param value The value for optional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetterEncloser withOptional(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.optional.equals(newValue)) return this;
    return new ImmutableGetterEncloser(newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GetterEncloser#optional() optional} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetterEncloser withOptional(Optional<Integer> optional) {
    Optional<Integer> value = optional;
    if (this.optional.equals(value)) return this;
    return new ImmutableGetterEncloser(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetterEncloser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetterEncloser
        && equalTo(0, (ImmutableGetterEncloser) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetterEncloser another) {
    return optional.equals(another.optional);
  }

  /**
   * Computes a hash code from attributes: {@code optional}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + optional.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetterEncloser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GetterEncloser")
        .omitNullValues()
        .add("optional", optional.orNull())
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GetterEncloser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetterEncloser instance
   */
  public static ImmutableGetterEncloser copyOf(GetterEncloser instance) {
    if (instance instanceof ImmutableGetterEncloser) {
      return (ImmutableGetterEncloser) instance;
    }
    return ImmutableGetterEncloser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetterEncloser ImmutableGetterEncloser}.
   * <pre>
   * ImmutableGetterEncloser.builder()
   *    .optional(Integer) // optional {@link GetterEncloser#optional() optional}
   *    .build();
   * </pre>
   * @return A new ImmutableGetterEncloser builder
   */
  public static ImmutableGetterEncloser.Builder builder() {
    return new ImmutableGetterEncloser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetterEncloser ImmutableGetterEncloser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetterEncloser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Optional<Integer> optional = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetterEncloser} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetterEncloser instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<Integer> optionalOptional = instance.optional();
      if (optionalOptional.isPresent()) {
        optional(optionalOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link GetterEncloser#optional() optional} to optional.
     * @param optional The value for optional
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder optional(int optional) {
      this.optional = Optional.of(optional);
      return this;
    }

    /**
     * Initializes the optional value {@link GetterEncloser#optional() optional} to optional.
     * @param optional The value for optional
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder optional(Optional<Integer> optional) {
      this.optional = optional;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetterEncloser ImmutableGetterEncloser}.
     * @return An immutable instance of GetterEncloser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetterEncloser build() {
      return new ImmutableGetterEncloser(optional);
    }
  }
}
