package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErgonomicFailureData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErgonomicFailureData.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableErgonomicFailureData.of()}.
 */
@Generated(from = "ErgonomicFailureData", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableErgonomicFailureData extends ErgonomicFailureData {
  private final String id;
  private final ImmutableList<String> listData;
  private final @Nullable ImmutableList<String> nullableData;
  private final Collection<String> collectionData;

  private ImmutableErgonomicFailureData(String id) {
    this.id = Objects.requireNonNull(id, "id");
    this.listData = ImmutableList.copyOf(super.listData());
    this.nullableData = super.nullableData() == null ? null : ImmutableList.copyOf(super.nullableData());
    this.collectionData = Objects.requireNonNull(super.collectionData(), "collectionData");
  }

  private ImmutableErgonomicFailureData(ImmutableErgonomicFailureData.Builder builder) {
    this.id = builder.id;
    this.listData = builder.listDataIsSet()
        ? builder.listData.build()
        : ImmutableList.copyOf(super.listData());
    this.nullableData = builder.nullableDataIsSet()
        ? builder.nullableData == null ? null : builder.nullableData.build()
        : super.nullableData() == null ? null : ImmutableList.copyOf(super.nullableData());
    this.collectionData = builder.collectionData != null
        ? builder.collectionData
        : Objects.requireNonNull(super.collectionData(), "collectionData");
  }

  private ImmutableErgonomicFailureData(
      String id,
      ImmutableList<String> listData,
      @Nullable ImmutableList<String> nullableData,
      Collection<String> collectionData) {
    this.id = id;
    this.listData = listData;
    this.nullableData = nullableData;
    this.collectionData = collectionData;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code listData} attribute
   */
  @Override
  public ImmutableList<String> listData() {
    return listData;
  }

  /**
   * @return The value of the {@code nullableData} attribute
   */
  @Override
  public @Nullable ImmutableList<String> nullableData() {
    return nullableData;
  }

  /**
   * @return The value of the {@code collectionData} attribute
   */
  @Override
  public Collection<String> collectionData() {
    return collectionData;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErgonomicFailureData#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErgonomicFailureData withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableErgonomicFailureData(newValue, this.listData, this.nullableData, this.collectionData);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErgonomicFailureData#listData() listData}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErgonomicFailureData withListData(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableErgonomicFailureData(this.id, newValue, this.nullableData, this.collectionData);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErgonomicFailureData#listData() listData}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of listData elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErgonomicFailureData withListData(Iterable<String> elements) {
    if (this.listData == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableErgonomicFailureData(this.id, newValue, this.nullableData, this.collectionData);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErgonomicFailureData#nullableData() nullableData}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErgonomicFailureData withNullableData(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableErgonomicFailureData(this.id, this.listData, null, this.collectionData);
    }
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableErgonomicFailureData(this.id, this.listData, newValue, this.collectionData);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErgonomicFailureData#nullableData() nullableData}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nullableData elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErgonomicFailureData withNullableData(@Nullable Iterable<String> elements) {
    if (this.nullableData == elements) return this;
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableErgonomicFailureData(this.id, this.listData, newValue, this.collectionData);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErgonomicFailureData#collectionData() collectionData} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionData
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErgonomicFailureData withCollectionData(Collection<String> value) {
    if (this.collectionData == value) return this;
    Collection<String> newValue = Objects.requireNonNull(value, "collectionData");
    return new ImmutableErgonomicFailureData(this.id, this.listData, this.nullableData, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErgonomicFailureData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErgonomicFailureData
        && equalTo(0, (ImmutableErgonomicFailureData) another);
  }

  private boolean equalTo(int synthetic, ImmutableErgonomicFailureData another) {
    return id.equals(another.id)
        && listData.equals(another.listData)
        && Objects.equals(nullableData, another.nullableData)
        && collectionData.equals(another.collectionData);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code listData}, {@code nullableData}, {@code collectionData}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + listData.hashCode();
    h += (h << 5) + Objects.hashCode(nullableData);
    h += (h << 5) + collectionData.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ErgonomicFailureData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErgonomicFailureData")
        .omitNullValues()
        .add("id", id)
        .add("listData", listData)
        .add("nullableData", nullableData)
        .add("collectionData", collectionData)
        .toString();
  }

  /**
   * Construct a new immutable {@code ErgonomicFailureData} instance.
   * @param id The value for the {@code id} attribute
   * @return An immutable ErgonomicFailureData instance
   */
  public static ImmutableErgonomicFailureData of(String id) {
    return new ImmutableErgonomicFailureData(id);
  }

  /**
   * Creates an immutable copy of a {@link ErgonomicFailureData} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ErgonomicFailureData instance
   */
  public static ImmutableErgonomicFailureData copyOf(ErgonomicFailureData instance) {
    if (instance instanceof ImmutableErgonomicFailureData) {
      return (ImmutableErgonomicFailureData) instance;
    }
    return ImmutableErgonomicFailureData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErgonomicFailureData ImmutableErgonomicFailureData}.
   * <pre>
   * ImmutableErgonomicFailureData.builder()
   *    .id(String) // required {@link ErgonomicFailureData#id() id}
   *    .addListData|addAllListData(String) // {@link ErgonomicFailureData#listData() listData} elements
   *    .nullableData(List&amp;lt;String&amp;gt; | null) // nullable {@link ErgonomicFailureData#nullableData() nullableData}
   *    .collectionData(Collection&amp;lt;String&amp;gt;) // optional {@link ErgonomicFailureData#collectionData() collectionData}
   *    .build();
   * </pre>
   * @return A new ImmutableErgonomicFailureData builder
   */
  public static ImmutableErgonomicFailureData.Builder builder() {
    return new ImmutableErgonomicFailureData.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErgonomicFailureData ImmutableErgonomicFailureData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErgonomicFailureData", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long OPT_BIT_LIST_DATA = 0x1L;
    private static final long OPT_BIT_NULLABLE_DATA = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String id;
    private ImmutableList.Builder<String> listData = ImmutableList.builder();
    private ImmutableList.Builder<String> nullableData = null;
    private @Nullable Collection<String> collectionData;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ErgonomicFailureData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ErgonomicFailureData instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      addAllListData(instance.listData());
      @Nullable List<String> nullableDataValue = instance.nullableData();
      if (nullableDataValue != null) {
        addAllNullableData(nullableDataValue);
      }
      collectionData(instance.collectionData());
      return this;
    }

    /**
     * Initializes the value for the {@link ErgonomicFailureData#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link ErgonomicFailureData#listData() listData} list.
     * @param element A listData element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addListData(String element) {
      this.listData.add(element);
      optBits |= OPT_BIT_LIST_DATA;
      return this;
    }

    /**
     * Adds elements to {@link ErgonomicFailureData#listData() listData} list.
     * @param elements An array of listData elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addListData(String... elements) {
      this.listData.add(elements);
      optBits |= OPT_BIT_LIST_DATA;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ErgonomicFailureData#listData() listData} list.
     * @param elements An iterable of listData elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder listData(Iterable<String> elements) {
      this.listData = ImmutableList.builder();
      return addAllListData(elements);
    }

    /**
     * Adds elements to {@link ErgonomicFailureData#listData() listData} list.
     * @param elements An iterable of listData elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllListData(Iterable<String> elements) {
      this.listData.addAll(elements);
      optBits |= OPT_BIT_LIST_DATA;
      return this;
    }

    /**
     * Adds one element to {@link ErgonomicFailureData#nullableData() nullableData} list.
     * @param element A nullableData element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNullableData(String element) {
      if (this.nullableData == null) {
        this.nullableData = ImmutableList.builder();
      }
      this.nullableData.add(element);
      optBits |= OPT_BIT_NULLABLE_DATA;
      return this;
    }

    /**
     * Adds elements to {@link ErgonomicFailureData#nullableData() nullableData} list.
     * @param elements An array of nullableData elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNullableData(String... elements) {
      if (this.nullableData == null) {
        this.nullableData = ImmutableList.builder();
      }
      this.nullableData.add(elements);
      optBits |= OPT_BIT_NULLABLE_DATA;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ErgonomicFailureData#nullableData() nullableData} list.
     * @param elements An iterable of nullableData elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nullableData(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.nullableData = null;
        optBits |= OPT_BIT_NULLABLE_DATA;
        return this;
      }
      this.nullableData = ImmutableList.builder();
      return addAllNullableData(elements);
    }

    /**
     * Adds elements to {@link ErgonomicFailureData#nullableData() nullableData} list.
     * @param elements An iterable of nullableData elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNullableData(Iterable<String> elements) {
      Objects.requireNonNull(elements, "nullableData element");
      if (this.nullableData == null) {
        this.nullableData = ImmutableList.builder();
      }
      this.nullableData.addAll(elements);
      optBits |= OPT_BIT_NULLABLE_DATA;
      return this;
    }

    /**
     * Initializes the value for the {@link ErgonomicFailureData#collectionData() collectionData} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ErgonomicFailureData#collectionData() collectionData}.</em>
     * @param collectionData The value for collectionData 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder collectionData(Collection<String> collectionData) {
      this.collectionData = Objects.requireNonNull(collectionData, "collectionData");
      return this;
    }

    /**
     * Builds a new {@link ImmutableErgonomicFailureData ImmutableErgonomicFailureData}.
     * @return An immutable instance of ErgonomicFailureData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErgonomicFailureData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableErgonomicFailureData(this);
    }

    private boolean listDataIsSet() {
      return (optBits & OPT_BIT_LIST_DATA) != 0;
    }

    private boolean nullableDataIsSet() {
      return (optBits & OPT_BIT_NULLABLE_DATA) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ErgonomicFailureData, some of required attributes are not set " + attributes;
    }
  }
}
