package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CustomEqualsWithTypeAnnotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCustomEqualsWithTypeAnnotation.builder()}.
 */
@Generated(from = "CustomEqualsWithTypeAnnotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCustomEqualsWithTypeAnnotation
    extends CustomEqualsWithTypeAnnotation {

  private ImmutableCustomEqualsWithTypeAnnotation(ImmutableCustomEqualsWithTypeAnnotation.Builder builder) {
  }

  /**
   * Prints the immutable value {@code CustomEqualsWithTypeAnnotation}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CustomEqualsWithTypeAnnotation{}";
  }

  /**
   * Creates an immutable copy of a {@link CustomEqualsWithTypeAnnotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomEqualsWithTypeAnnotation instance
   */
  public static ImmutableCustomEqualsWithTypeAnnotation copyOf(CustomEqualsWithTypeAnnotation instance) {
    if (instance instanceof ImmutableCustomEqualsWithTypeAnnotation) {
      return (ImmutableCustomEqualsWithTypeAnnotation) instance;
    }
    return ImmutableCustomEqualsWithTypeAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCustomEqualsWithTypeAnnotation ImmutableCustomEqualsWithTypeAnnotation}.
   * <pre>
   * ImmutableCustomEqualsWithTypeAnnotation.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableCustomEqualsWithTypeAnnotation builder
   */
  public static ImmutableCustomEqualsWithTypeAnnotation.Builder builder() {
    return new ImmutableCustomEqualsWithTypeAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCustomEqualsWithTypeAnnotation ImmutableCustomEqualsWithTypeAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CustomEqualsWithTypeAnnotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomEqualsWithTypeAnnotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CustomEqualsWithTypeAnnotation instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableCustomEqualsWithTypeAnnotation ImmutableCustomEqualsWithTypeAnnotation}.
     * @return An immutable instance of CustomEqualsWithTypeAnnotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomEqualsWithTypeAnnotation build() {
      return new ImmutableCustomEqualsWithTypeAnnotation(this);
    }
  }
}
