package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableAttributeOrdering} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link AttributeOrdering}.
 * @see ImmutableAttributeOrdering.D
 * @see ImmutableAttributeOrdering.SourceOrderingEntity
 */
@Generated(from = "AttributeOrdering", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableAttributeOrdering {
  private ImmutableAttributeOrdering() {}

  /**
   * Immutable implementation of {@link AttributeOrdering.D}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableAttributeOrdering.D.builder()}.
   */
  @Generated(from = "AttributeOrdering.D", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class D implements AttributeOrdering.D {
    private final int a1;
    private final int a2;
    private final int b1;
    private final int b2;
    private final int c1;
    private final int c2;
    private final int d;

    private D(int a1, int a2, int b1, int b2, int c1, int c2, int d) {
      this.a1 = a1;
      this.a2 = a2;
      this.b1 = b1;
      this.b2 = b2;
      this.c1 = c1;
      this.c2 = c2;
      this.d = d;
    }

    /**
     * @return The value of the {@code a1} attribute
     */
    @Override
    public int a1() {
      return a1;
    }

    /**
     * @return The value of the {@code a2} attribute
     */
    @Override
    public int a2() {
      return a2;
    }

    /**
     * @return The value of the {@code b1} attribute
     */
    @Override
    public int b1() {
      return b1;
    }

    /**
     * @return The value of the {@code b2} attribute
     */
    @Override
    public int b2() {
      return b2;
    }

    /**
     * @return The value of the {@code c1} attribute
     */
    @Override
    public int c1() {
      return c1;
    }

    /**
     * @return The value of the {@code c2} attribute
     */
    @Override
    public int c2() {
      return c2;
    }

    /**
     * @return The value of the {@code d} attribute
     */
    @Override
    public int d() {
      return d;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.D#a1() a1} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a1
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.D withA1(int value) {
      if (this.a1 == value) return this;
      return new ImmutableAttributeOrdering.D(value, this.a2, this.b1, this.b2, this.c1, this.c2, this.d);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.D#a2() a2} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a2
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.D withA2(int value) {
      if (this.a2 == value) return this;
      return new ImmutableAttributeOrdering.D(this.a1, value, this.b1, this.b2, this.c1, this.c2, this.d);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.D#b1() b1} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for b1
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.D withB1(int value) {
      if (this.b1 == value) return this;
      return new ImmutableAttributeOrdering.D(this.a1, this.a2, value, this.b2, this.c1, this.c2, this.d);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.D#b2() b2} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for b2
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.D withB2(int value) {
      if (this.b2 == value) return this;
      return new ImmutableAttributeOrdering.D(this.a1, this.a2, this.b1, value, this.c1, this.c2, this.d);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.D#c1() c1} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for c1
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.D withC1(int value) {
      if (this.c1 == value) return this;
      return new ImmutableAttributeOrdering.D(this.a1, this.a2, this.b1, this.b2, value, this.c2, this.d);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.D#c2() c2} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for c2
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.D withC2(int value) {
      if (this.c2 == value) return this;
      return new ImmutableAttributeOrdering.D(this.a1, this.a2, this.b1, this.b2, this.c1, value, this.d);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.D#d() d} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for d
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.D withD(int value) {
      if (this.d == value) return this;
      return new ImmutableAttributeOrdering.D(this.a1, this.a2, this.b1, this.b2, this.c1, this.c2, value);
    }

    /**
     * This instance is equal to all instances of {@code D} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableAttributeOrdering.D
          && equalTo(0, (ImmutableAttributeOrdering.D) another);
    }

    private boolean equalTo(int synthetic, ImmutableAttributeOrdering.D another) {
      return a1 == another.a1
          && a2 == another.a2
          && b1 == another.b1
          && b2 == another.b2
          && c1 == another.c1
          && c2 == another.c2
          && d == another.d;
    }

    /**
     * Computes a hash code from attributes: {@code a1}, {@code a2}, {@code b1}, {@code b2}, {@code c1}, {@code c2}, {@code d}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + a1;
      h += (h << 5) + a2;
      h += (h << 5) + b1;
      h += (h << 5) + b2;
      h += (h << 5) + c1;
      h += (h << 5) + c2;
      h += (h << 5) + d;
      return h;
    }

    /**
     * Prints the immutable value {@code D} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("D")
          .omitNullValues()
          .add("a1", a1)
          .add("a2", a2)
          .add("b1", b1)
          .add("b2", b2)
          .add("c1", c1)
          .add("c2", c2)
          .add("d", d)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link AttributeOrdering.D} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable D instance
     */
    public static ImmutableAttributeOrdering.D copyOf(AttributeOrdering.D instance) {
      if (instance instanceof ImmutableAttributeOrdering.D) {
        return (ImmutableAttributeOrdering.D) instance;
      }
      return ImmutableAttributeOrdering.D.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableAttributeOrdering.D D}.
     * <pre>
     * ImmutableAttributeOrdering.D.builder()
     *    .a1(int) // required {@link AttributeOrdering.D#a1() a1}
     *    .a2(int) // required {@link AttributeOrdering.D#a2() a2}
     *    .b1(int) // required {@link AttributeOrdering.D#b1() b1}
     *    .b2(int) // required {@link AttributeOrdering.D#b2() b2}
     *    .c1(int) // required {@link AttributeOrdering.D#c1() c1}
     *    .c2(int) // required {@link AttributeOrdering.D#c2() c2}
     *    .d(int) // required {@link AttributeOrdering.D#d() d}
     *    .build();
     * </pre>
     * @return A new D builder
     */
    public static ImmutableAttributeOrdering.D.Builder builder() {
      return new ImmutableAttributeOrdering.D.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableAttributeOrdering.D D}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "AttributeOrdering.D", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_A1 = 0x1L;
      private static final long INIT_BIT_A2 = 0x2L;
      private static final long INIT_BIT_B1 = 0x4L;
      private static final long INIT_BIT_B2 = 0x8L;
      private static final long INIT_BIT_C1 = 0x10L;
      private static final long INIT_BIT_C2 = 0x20L;
      private static final long INIT_BIT_D = 0x40L;
      private long initBits = 0x7fL;

      private int a1;
      private int a2;
      private int b1;
      private int b2;
      private int c1;
      private int c2;
      private int d;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.AttributeOrdering.D} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(AttributeOrdering.D instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.AttributeOrdering.B} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(AttributeOrdering.B instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.AttributeOrdering.C} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(AttributeOrdering.C instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.AttributeOrdering.A} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(AttributeOrdering.A instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        @Var long bits = 0;
        if (object instanceof AttributeOrdering.D) {
          AttributeOrdering.D instance = (AttributeOrdering.D) object;
          if ((bits & 0x1L) == 0) {
            a1(instance.a1());
            bits |= 0x1L;
          }
          if ((bits & 0x2L) == 0) {
            b2(instance.b2());
            bits |= 0x2L;
          }
          if ((bits & 0x4L) == 0) {
            a2(instance.a2());
            bits |= 0x4L;
          }
          d(instance.d());
          if ((bits & 0x8L) == 0) {
            c1(instance.c1());
            bits |= 0x8L;
          }
          if ((bits & 0x10L) == 0) {
            b1(instance.b1());
            bits |= 0x10L;
          }
          if ((bits & 0x20L) == 0) {
            c2(instance.c2());
            bits |= 0x20L;
          }
        }
        if (object instanceof AttributeOrdering.B) {
          AttributeOrdering.B instance = (AttributeOrdering.B) object;
          if ((bits & 0x1L) == 0) {
            a1(instance.a1());
            bits |= 0x1L;
          }
          if ((bits & 0x2L) == 0) {
            b2(instance.b2());
            bits |= 0x2L;
          }
          if ((bits & 0x4L) == 0) {
            a2(instance.a2());
            bits |= 0x4L;
          }
          if ((bits & 0x10L) == 0) {
            b1(instance.b1());
            bits |= 0x10L;
          }
        }
        if (object instanceof AttributeOrdering.C) {
          AttributeOrdering.C instance = (AttributeOrdering.C) object;
          if ((bits & 0x1L) == 0) {
            a1(instance.a1());
            bits |= 0x1L;
          }
          if ((bits & 0x4L) == 0) {
            a2(instance.a2());
            bits |= 0x4L;
          }
          if ((bits & 0x8L) == 0) {
            c1(instance.c1());
            bits |= 0x8L;
          }
          if ((bits & 0x20L) == 0) {
            c2(instance.c2());
            bits |= 0x20L;
          }
        }
        if (object instanceof AttributeOrdering.A) {
          AttributeOrdering.A instance = (AttributeOrdering.A) object;
          if ((bits & 0x1L) == 0) {
            a1(instance.a1());
            bits |= 0x1L;
          }
          if ((bits & 0x4L) == 0) {
            a2(instance.a2());
            bits |= 0x4L;
          }
        }
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.D#a1() a1} attribute.
       * @param a1 The value for a1 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder a1(int a1) {
        this.a1 = a1;
        initBits &= ~INIT_BIT_A1;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.D#a2() a2} attribute.
       * @param a2 The value for a2 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder a2(int a2) {
        this.a2 = a2;
        initBits &= ~INIT_BIT_A2;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.D#b1() b1} attribute.
       * @param b1 The value for b1 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder b1(int b1) {
        this.b1 = b1;
        initBits &= ~INIT_BIT_B1;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.D#b2() b2} attribute.
       * @param b2 The value for b2 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder b2(int b2) {
        this.b2 = b2;
        initBits &= ~INIT_BIT_B2;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.D#c1() c1} attribute.
       * @param c1 The value for c1 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder c1(int c1) {
        this.c1 = c1;
        initBits &= ~INIT_BIT_C1;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.D#c2() c2} attribute.
       * @param c2 The value for c2 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder c2(int c2) {
        this.c2 = c2;
        initBits &= ~INIT_BIT_C2;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.D#d() d} attribute.
       * @param d The value for d 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder d(int d) {
        this.d = d;
        initBits &= ~INIT_BIT_D;
        return this;
      }

      /**
       * Builds a new {@link ImmutableAttributeOrdering.D D}.
       * @return An immutable instance of D
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableAttributeOrdering.D build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableAttributeOrdering.D(a1, a2, b1, b2, c1, c2, d);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_A1) != 0) attributes.add("a1");
        if ((initBits & INIT_BIT_A2) != 0) attributes.add("a2");
        if ((initBits & INIT_BIT_B1) != 0) attributes.add("b1");
        if ((initBits & INIT_BIT_B2) != 0) attributes.add("b2");
        if ((initBits & INIT_BIT_C1) != 0) attributes.add("c1");
        if ((initBits & INIT_BIT_C2) != 0) attributes.add("c2");
        if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
        return "Cannot build D, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link AttributeOrdering.SourceOrderingEntity}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableAttributeOrdering.SourceOrderingEntity.builder()}.
   */
  @Generated(from = "AttributeOrdering.SourceOrderingEntity", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class SourceOrderingEntity
      extends AttributeOrdering.SourceOrderingEntity {
    private final int b;
    private final int a;
    private final int z;
    private final int y;

    private SourceOrderingEntity(int b, int a, int z, int y) {
      this.b = b;
      this.a = a;
      this.z = z;
      this.y = y;
    }

    /**
     * @return The value of the {@code b} attribute
     */
    @Override
    public int b() {
      return b;
    }

    /**
     * @return The value of the {@code a} attribute
     */
    @Override
    public int a() {
      return a;
    }

    /**
     * @return The value of the {@code z} attribute
     */
    @Override
    public int z() {
      return z;
    }

    /**
     * @return The value of the {@code y} attribute
     */
    @Override
    public int y() {
      return y;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.SourceOrderingEntity#b() b} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for b
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.SourceOrderingEntity withB(int value) {
      if (this.b == value) return this;
      return new ImmutableAttributeOrdering.SourceOrderingEntity(value, this.a, this.z, this.y);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.SourceOrderingEntity#a() a} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.SourceOrderingEntity withA(int value) {
      if (this.a == value) return this;
      return new ImmutableAttributeOrdering.SourceOrderingEntity(this.b, value, this.z, this.y);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.SourceOrderingEntity#z() z} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for z
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.SourceOrderingEntity withZ(int value) {
      if (this.z == value) return this;
      return new ImmutableAttributeOrdering.SourceOrderingEntity(this.b, this.a, value, this.y);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AttributeOrdering.SourceOrderingEntity#y() y} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for y
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableAttributeOrdering.SourceOrderingEntity withY(int value) {
      if (this.y == value) return this;
      return new ImmutableAttributeOrdering.SourceOrderingEntity(this.b, this.a, this.z, value);
    }

    /**
     * This instance is equal to all instances of {@code SourceOrderingEntity} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableAttributeOrdering.SourceOrderingEntity
          && equalTo(0, (ImmutableAttributeOrdering.SourceOrderingEntity) another);
    }

    private boolean equalTo(int synthetic, ImmutableAttributeOrdering.SourceOrderingEntity another) {
      return b == another.b
          && a == another.a
          && z == another.z
          && y == another.y;
    }

    /**
     * Computes a hash code from attributes: {@code b}, {@code a}, {@code z}, {@code y}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + b;
      h += (h << 5) + a;
      h += (h << 5) + z;
      h += (h << 5) + y;
      return h;
    }

    /**
     * Prints the immutable value {@code SourceOrderingEntity} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("SourceOrderingEntity")
          .omitNullValues()
          .add("b", b)
          .add("a", a)
          .add("z", z)
          .add("y", y)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link AttributeOrdering.SourceOrderingEntity} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable SourceOrderingEntity instance
     */
    public static ImmutableAttributeOrdering.SourceOrderingEntity copyOf(AttributeOrdering.SourceOrderingEntity instance) {
      if (instance instanceof ImmutableAttributeOrdering.SourceOrderingEntity) {
        return (ImmutableAttributeOrdering.SourceOrderingEntity) instance;
      }
      return ImmutableAttributeOrdering.SourceOrderingEntity.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableAttributeOrdering.SourceOrderingEntity SourceOrderingEntity}.
     * <pre>
     * ImmutableAttributeOrdering.SourceOrderingEntity.builder()
     *    .b(int) // required {@link AttributeOrdering.SourceOrderingEntity#b() b}
     *    .a(int) // required {@link AttributeOrdering.SourceOrderingEntity#a() a}
     *    .z(int) // required {@link AttributeOrdering.SourceOrderingEntity#z() z}
     *    .y(int) // required {@link AttributeOrdering.SourceOrderingEntity#y() y}
     *    .build();
     * </pre>
     * @return A new SourceOrderingEntity builder
     */
    public static ImmutableAttributeOrdering.SourceOrderingEntity.Builder builder() {
      return new ImmutableAttributeOrdering.SourceOrderingEntity.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableAttributeOrdering.SourceOrderingEntity SourceOrderingEntity}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "AttributeOrdering.SourceOrderingEntity", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_B = 0x1L;
      private static final long INIT_BIT_A = 0x2L;
      private static final long INIT_BIT_Z = 0x4L;
      private static final long INIT_BIT_Y = 0x8L;
      private long initBits = 0xfL;

      private int b;
      private int a;
      private int z;
      private int y;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.AttributeOrdering.SourceOrderingEntity} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(AttributeOrdering.SourceOrderingEntity instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.AttributeOrdering.InheritedInterface} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(AttributeOrdering.InheritedInterface instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof AttributeOrdering.SourceOrderingEntity) {
          AttributeOrdering.SourceOrderingEntity instance = (AttributeOrdering.SourceOrderingEntity) object;
          z(instance.z());
        }
        if (object instanceof AttributeOrdering.InheritedInterface) {
          AttributeOrdering.InheritedInterface instance = (AttributeOrdering.InheritedInterface) object;
          a(instance.a());
          y(instance.y());
          b(instance.b());
        }
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.SourceOrderingEntity#b() b} attribute.
       * @param b The value for b 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder b(int b) {
        this.b = b;
        initBits &= ~INIT_BIT_B;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.SourceOrderingEntity#a() a} attribute.
       * @param a The value for a 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder a(int a) {
        this.a = a;
        initBits &= ~INIT_BIT_A;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.SourceOrderingEntity#z() z} attribute.
       * @param z The value for z 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder z(int z) {
        this.z = z;
        initBits &= ~INIT_BIT_Z;
        return this;
      }

      /**
       * Initializes the value for the {@link AttributeOrdering.SourceOrderingEntity#y() y} attribute.
       * @param y The value for y 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder y(int y) {
        this.y = y;
        initBits &= ~INIT_BIT_Y;
        return this;
      }

      /**
       * Builds a new {@link ImmutableAttributeOrdering.SourceOrderingEntity SourceOrderingEntity}.
       * @return An immutable instance of SourceOrderingEntity
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableAttributeOrdering.SourceOrderingEntity build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableAttributeOrdering.SourceOrderingEntity(b, a, z, y);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
        if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
        if ((initBits & INIT_BIT_Z) != 0) attributes.add("z");
        if ((initBits & INIT_BIT_Y) != 0) attributes.add("y");
        return "Cannot build SourceOrderingEntity, some of required attributes are not set " + attributes;
      }
    }
  }
}
