package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AllParametersDefaultInit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAllParametersDefaultInit.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAllParametersDefaultInit.of()}.
 */
@Generated(from = "AllParametersDefaultInit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAllParametersDefaultInit
    implements AllParametersDefaultInit {
  private final String foo;
  private final boolean isBar;

  private ImmutableAllParametersDefaultInit(String foo, boolean isBar) {
    this.foo = Objects.requireNonNull(foo, "foo");
    this.isBar = isBar;
    this.initShim = null;
  }

  private ImmutableAllParametersDefaultInit(ImmutableAllParametersDefaultInit.Builder builder) {
    if (builder.foo != null) {
      initShim.foo(builder.foo);
    }
    if (builder.isBarIsSet()) {
      initShim.isBar(builder.isBar);
    }
    this.foo = initShim.getFoo();
    this.isBar = initShim.isBar();
    this.initShim = null;
  }

  private ImmutableAllParametersDefaultInit(ImmutableAllParametersDefaultInit original, String foo, boolean isBar) {
    this.foo = foo;
    this.isBar = isBar;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AllParametersDefaultInit", generator = "Immutables")
  private final class InitShim {
    private byte fooBuildStage = STAGE_UNINITIALIZED;
    private String foo;

    String getFoo() {
      if (fooBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fooBuildStage == STAGE_UNINITIALIZED) {
        fooBuildStage = STAGE_INITIALIZING;
        this.foo = Objects.requireNonNull(getFooInitialize(), "foo");
        fooBuildStage = STAGE_INITIALIZED;
      }
      return this.foo;
    }

    void foo(String foo) {
      this.foo = foo;
      fooBuildStage = STAGE_INITIALIZED;
    }

    private byte isBarBuildStage = STAGE_UNINITIALIZED;
    private boolean isBar;

    boolean isBar() {
      if (isBarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBarBuildStage == STAGE_UNINITIALIZED) {
        isBarBuildStage = STAGE_INITIALIZING;
        this.isBar = isBarInitialize();
        isBarBuildStage = STAGE_INITIALIZED;
      }
      return this.isBar;
    }

    void isBar(boolean isBar) {
      this.isBar = isBar;
      isBarBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (fooBuildStage == STAGE_INITIALIZING) attributes.add("foo");
      if (isBarBuildStage == STAGE_INITIALIZING) attributes.add("isBar");
      return "Cannot build AllParametersDefaultInit, attribute initializers form cycle " + attributes;
    }
  }

  private String getFooInitialize() {
    return AllParametersDefaultInit.super.getFoo();
  }

  private boolean isBarInitialize() {
    return AllParametersDefaultInit.super.isBar();
  }

  /**
   * @return The value of the {@code foo} attribute
   */
  @Override
  public String getFoo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFoo()
        : this.foo;
  }

  /**
   * @return The value of the {@code isBar} attribute
   */
  @Override
  public boolean isBar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBar()
        : this.isBar;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllParametersDefaultInit#getFoo() foo} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for foo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllParametersDefaultInit withFoo(String value) {
    String newValue = Objects.requireNonNull(value, "foo");
    if (this.foo.equals(newValue)) return this;
    return new ImmutableAllParametersDefaultInit(this, newValue, this.isBar);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllParametersDefaultInit#isBar() isBar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isBar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllParametersDefaultInit withIsBar(boolean value) {
    if (this.isBar == value) return this;
    return new ImmutableAllParametersDefaultInit(this, this.foo, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAllParametersDefaultInit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAllParametersDefaultInit
        && equalTo(0, (ImmutableAllParametersDefaultInit) another);
  }

  private boolean equalTo(int synthetic, ImmutableAllParametersDefaultInit another) {
    return foo.equals(another.foo)
        && isBar == another.isBar;
  }

  /**
   * Computes a hash code from attributes: {@code foo}, {@code isBar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + foo.hashCode();
    h += (h << 5) + Booleans.hashCode(isBar);
    return h;
  }

  /**
   * Prints the immutable value {@code AllParametersDefaultInit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AllParametersDefaultInit")
        .omitNullValues()
        .add("foo", foo)
        .add("isBar", isBar)
        .toString();
  }

  /**
   * Construct a new immutable {@code AllParametersDefaultInit} instance.
   * @param foo The value for the {@code foo} attribute
   * @param isBar The value for the {@code isBar} attribute
   * @return An immutable AllParametersDefaultInit instance
   */
  public static ImmutableAllParametersDefaultInit of(String foo, boolean isBar) {
    return new ImmutableAllParametersDefaultInit(foo, isBar);
  }

  /**
   * Creates an immutable copy of a {@link AllParametersDefaultInit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AllParametersDefaultInit instance
   */
  public static ImmutableAllParametersDefaultInit copyOf(AllParametersDefaultInit instance) {
    if (instance instanceof ImmutableAllParametersDefaultInit) {
      return (ImmutableAllParametersDefaultInit) instance;
    }
    return ImmutableAllParametersDefaultInit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAllParametersDefaultInit ImmutableAllParametersDefaultInit}.
   * <pre>
   * ImmutableAllParametersDefaultInit.builder()
   *    .foo(String) // optional {@link AllParametersDefaultInit#getFoo() foo}
   *    .isBar(boolean) // optional {@link AllParametersDefaultInit#isBar() isBar}
   *    .build();
   * </pre>
   * @return A new ImmutableAllParametersDefaultInit builder
   */
  public static ImmutableAllParametersDefaultInit.Builder builder() {
    return new ImmutableAllParametersDefaultInit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAllParametersDefaultInit ImmutableAllParametersDefaultInit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AllParametersDefaultInit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_IS_BAR = 0x1L;
    private long optBits;

    private @Nullable String foo;
    private boolean isBar;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AllParametersDefaultInit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AllParametersDefaultInit instance) {
      Objects.requireNonNull(instance, "instance");
      foo(instance.getFoo());
      isBar(instance.isBar());
      return this;
    }

    /**
     * Initializes the value for the {@link AllParametersDefaultInit#getFoo() foo} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AllParametersDefaultInit#getFoo() foo}.</em>
     * @param foo The value for foo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder foo(String foo) {
      this.foo = Objects.requireNonNull(foo, "foo");
      return this;
    }

    /**
     * Initializes the value for the {@link AllParametersDefaultInit#isBar() isBar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AllParametersDefaultInit#isBar() isBar}.</em>
     * @param isBar The value for isBar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isBar(boolean isBar) {
      this.isBar = isBar;
      optBits |= OPT_BIT_IS_BAR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAllParametersDefaultInit ImmutableAllParametersDefaultInit}.
     * @return An immutable instance of AllParametersDefaultInit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAllParametersDefaultInit build() {
      return new ImmutableAllParametersDefaultInit(this);
    }

    private boolean isBarIsSet() {
      return (optBits & OPT_BIT_IS_BAR) != 0;
    }
  }
}
