package org.immutables.fixture;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyTuplie}.
 * @see ImmutableSillyTuplie
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyTuplie implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyTuplieTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyTuplieTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyTuplie(SillyTuplie)";
  }

  @org.immutables.value.Generated(from = "SillyTuplie", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyTuplieTypeAdapter extends TypeAdapter<SillyTuplie> {
    public final Byte opt2TypeSample = null;
    public final Boolean set3TypeSample = null;
    private final TypeAdapter<Byte> opt2TypeAdapter;
    private final TypeAdapter<Boolean> set3TypeAdapter;

    SillyTuplieTypeAdapter(Gson gson) {
      this.opt2TypeAdapter = gson.getAdapter( Byte.class);
      this.set3TypeAdapter = gson.getAdapter( Boolean.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyTuplie.class == type.getRawType()
          || ImmutableSillyTuplie.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyTuplie value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyTuplie(out, value);
      }
    }

    @Override
    public SillyTuplie read(JsonReader in) throws IOException {
      return readSillyTuplie(in);
    }

    private void writeSillyTuplie(JsonWriter out, SillyTuplie instance)
        throws IOException {
      out.beginArray();
      out.value(instance.float1());
      Optional<Byte> opt2Optional = instance.opt2();
      if (opt2Optional.isPresent()) {
        Byte opt2Value = opt2Optional.get();
        opt2TypeAdapter.write(out, opt2Value);
      } else {
        out.nullValue();
      }
      out.beginArray();
      for (boolean e : instance.set3()) {
        set3TypeAdapter.write(out, e);
      }
      out.endArray();
      out.endArray();
    }

    private  SillyTuplie readSillyTuplie(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      in.beginArray();
      SillyTuplie instance = ImmutableSillyTuplie.of(
        readParameterFloat1(in),
        readParameterOpt2(in),
        readParameterSet3(in));
      in.endArray();
      return instance;
    }

    private static float readParameterFloat1(JsonReader in)
        throws IOException {
      return (float) in.nextDouble();
    }

    private  Optional<Byte> readParameterOpt2(JsonReader in)
        throws IOException {
      JsonToken t = in.peek();
      if (t == JsonToken.NULL) {
        in.nextNull();
        return Optional.absent();
      }
      Byte value = opt2TypeAdapter.read(in);
      return Optional.of(value);
    }

    private  Iterable<Boolean> readParameterSet3(JsonReader in)
        throws IOException {
      ImmutableSet.Builder<Boolean> elements = ImmutableSet.builder();
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          elements.add(in.nextBoolean());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        elements.add(in.nextBoolean());
      }
      return elements.build();
    }
  }
}
