package org.immutables.fixture;

import com.google.common.base.Optional;
import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.gson.adapter.ExpectedSubtypesAdapter;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyPolyHost2}.
 * @see ImmutableSillyPolyHost2
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyPolyHost2 implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyPolyHost2TypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyPolyHost2TypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyPolyHost2(SillyPolyHost2)";
  }

  @org.immutables.value.Generated(from = "SillyPolyHost2", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyPolyHost2TypeAdapter extends TypeAdapter<SillyPolyHost2> {
    public final SillyAbstract sTypeSample = null;
    public final SillyAbstract oTypeSample = null;
    private final TypeAdapter<SillyAbstract> sTypeAdapter;
    private final TypeAdapter<SillyAbstract> oTypeAdapter;

    SillyPolyHost2TypeAdapter(Gson gson) {
      this.sTypeAdapter = ExpectedSubtypesAdapter.create(gson,
          SillyAbstract.class,
          TypeToken.get(SillySub2.class),
          TypeToken.get(SillySub3.class));
      this.oTypeAdapter = ExpectedSubtypesAdapter.create(gson,
          SillyAbstract.class,
          TypeToken.get(SillySub2.class),
          TypeToken.get(SillySub3.class));
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyPolyHost2.class == type.getRawType()
          || ImmutableSillyPolyHost2.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyPolyHost2 value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyPolyHost2(out, value);
      }
    }

    @Override
    public SillyPolyHost2 read(JsonReader in) throws IOException {
      return readSillyPolyHost2(in);
    }

    private void writeSillyPolyHost2(JsonWriter out, SillyPolyHost2 instance)
        throws IOException {
      out.beginObject();
      out.name("s");
      sTypeAdapter.write(out, instance.s());
      Optional<SillyAbstract> oOptional = instance.o();
      if (oOptional.isPresent()) {
        out.name("o");
        SillyAbstract oValue = oOptional.get();
        oTypeAdapter.write(out, oValue);
      } else if (out.getSerializeNulls()) {
        out.name("o");
        out.nullValue();
      }
      out.endObject();
    }

    private  SillyPolyHost2 readSillyPolyHost2(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSillyPolyHost2.Builder builder = ImmutableSillyPolyHost2.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSillyPolyHost2.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 's':
        if ("s".equals(attributeName)) {
          readInS(in, builder);
          return;
        }
        break;
      case 'o':
        if ("o".equals(attributeName)) {
          readInO(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInS(JsonReader in, ImmutableSillyPolyHost2.Builder builder)
        throws IOException {
      SillyAbstract value = sTypeAdapter.read(in);
      builder.s(value);
    }

    private void readInO(JsonReader in, ImmutableSillyPolyHost2.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        SillyAbstract value = oTypeAdapter.read(in);
        builder.o(value);
      }
    }
  }
}
