package org.immutables.fixture;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyMapHolder}.
 * @see ImmutableSillyMapHolder
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyMapHolder implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyMapHolderTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyMapHolderTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyMapHolder(SillyMapHolder)";
  }

  @org.immutables.value.Generated(from = "SillyMapHolder", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyMapHolderTypeAdapter extends TypeAdapter<SillyMapHolder> {
    public final SillyValue holder1TypeSample = null;
    public final Integer holder1SecondaryTypeSample = null;
    public final Integer holder2TypeSample = null;
    public final SillyMapTup holder3SecondaryTypeSample = null;
    public final RetentionPolicy zzTypeSample = null;
    private final TypeAdapter<SillyValue> holder1TypeAdapter;
    private final TypeAdapter<Integer> holder1SecondaryTypeAdapter;
    private final TypeAdapter<Integer> holder2TypeAdapter;
    private final TypeAdapter<SillyMapTup> holder3SecondaryTypeAdapter;
    private final TypeAdapter<RetentionPolicy> zzTypeAdapter;

    SillyMapHolderTypeAdapter(Gson gson) {
      this.holder1TypeAdapter = gson.getAdapter( SillyValue.class);
      this.holder1SecondaryTypeAdapter = gson.getAdapter( Integer.class);
      this.holder2TypeAdapter = gson.getAdapter( Integer.class);
      this.holder3SecondaryTypeAdapter = gson.getAdapter( SillyMapTup.class);
      this.zzTypeAdapter = gson.getAdapter( RetentionPolicy.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyMapHolder.class == type.getRawType()
          || ImmutableSillyMapHolder.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyMapHolder value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyMapHolder(out, value);
      }
    }

    @Override
    public SillyMapHolder read(JsonReader in) throws IOException {
      return readSillyMapHolder(in);
    }

    private void writeSillyMapHolder(JsonWriter out, SillyMapHolder instance)
        throws IOException {
      out.beginObject();
      Map<SillyValue, Integer> holder1Mapping = instance.holder1();
      out.name("holder1");
      out.beginObject();
      for (Map.Entry<SillyValue, Integer> e : holder1Mapping.entrySet()) {
        String key = holder1TypeAdapter.toJsonTree(e.getKey()).getAsString();
        out.name(key);
        int value = e.getValue();
        holder1SecondaryTypeAdapter.write(out, value);
      }
      out.endObject();
      Map<Integer, String> holder2Mapping = instance.holder2();
      out.name("holder2");
      out.beginObject();
      for (Map.Entry<Integer, String> e : holder2Mapping.entrySet()) {
        String key = String.valueOf(e.getKey());
        out.name(key);
        String value = e.getValue();
        out.value(value);
      }
      out.endObject();
      Map<String, SillyMapTup> holder3Mapping = instance.holder3();
      out.name("holder3");
      out.beginObject();
      for (Map.Entry<String, SillyMapTup> e : holder3Mapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        SillyMapTup value = e.getValue();
        holder3SecondaryTypeAdapter.write(out, value);
      }
      out.endObject();
      Set<RetentionPolicy> zzElements = instance.zz();
      out.name("zz");
      out.beginArray();
      for (RetentionPolicy e : zzElements) {
        zzTypeAdapter.write(out, e);
      }
      out.endArray();
      out.endObject();
    }

    private  SillyMapHolder readSillyMapHolder(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSillyMapHolder.Builder builder = ImmutableSillyMapHolder.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSillyMapHolder.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'h':
        if ("holder1".equals(attributeName)) {
          readInHolder1(in, builder);
          return;
        }
        if ("holder2".equals(attributeName)) {
          readInHolder2(in, builder);
          return;
        }
        if ("holder3".equals(attributeName)) {
          readInHolder3(in, builder);
          return;
        }
        break;
      case 'z':
        if ("zz".equals(attributeName)) {
          readInZz(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInHolder1(JsonReader in, ImmutableSillyMapHolder.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          SillyValue key = holder1TypeAdapter.fromJsonTree(new JsonPrimitive(rawKey));
          Integer value = holder1SecondaryTypeAdapter.read(in);
          builder.putHolder1(key, value);
        }
        in.endObject();
      }
    }

    private void readInHolder2(JsonReader in, ImmutableSillyMapHolder.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          int key = Integer.parseInt(rawKey);
          String value = in.nextString();
          builder.putHolder2(key, value);
        }
        in.endObject();
      }
    }

    private void readInHolder3(JsonReader in, ImmutableSillyMapHolder.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          SillyMapTup value = holder3SecondaryTypeAdapter.read(in);
          builder.putHolder3(key, value);
        }
        in.endObject();
      }
    }

    private void readInZz(JsonReader in, ImmutableSillyMapHolder.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          RetentionPolicy value = zzTypeAdapter.read(in);
          builder.addZz(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        RetentionPolicy value = zzTypeAdapter.read(in);
        builder.addZz(value);
      }
    }
  }
}
