package org.immutables.fixture;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code HasNullable}.
 * @see ImmutableHasNullable
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersHasNullable implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (HasNullableTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new HasNullableTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersHasNullable(HasNullable)";
  }

  @org.immutables.value.Generated(from = "HasNullable", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class HasNullableTypeAdapter extends TypeAdapter<HasNullable> {
    public final Integer inTypeSample = null;
    private final TypeAdapter<Integer> inTypeAdapter;

    HasNullableTypeAdapter(Gson gson) {
      this.inTypeAdapter = gson.getAdapter( Integer.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return HasNullable.class == type.getRawType()
          || ImmutableHasNullable.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, HasNullable value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeHasNullable(out, value);
      }
    }

    @Override
    public HasNullable read(JsonReader in) throws IOException {
      return readHasNullable(in);
    }

    private void writeHasNullable(JsonWriter out, HasNullable instance)
        throws IOException {
      out.beginObject();
      @Nullable Integer inValue = instance.in();
      if (inValue != null) {
        out.name("in");
        inTypeAdapter.write(out, inValue);
      } else if (out.getSerializeNulls()) {
        out.name("in");
        out.nullValue();
      }
      @Nullable String defValue = instance.def();
      if (defValue != null) {
        out.name("def");
        out.value(defValue);
      } else if (out.getSerializeNulls()) {
        out.name("def");
        out.nullValue();
      }
      @Nullable String derValue = instance.der();
      if (derValue != null) {
        out.name("der");
        out.value(derValue);
      } else if (out.getSerializeNulls()) {
        out.name("der");
        out.nullValue();
      }
      out.endObject();
    }

    private  HasNullable readHasNullable(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableHasNullable.Builder builder = ImmutableHasNullable.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableHasNullable.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("in".equals(attributeName)) {
          readInIn(in, builder);
          return;
        }
        break;
      case 'd':
        if ("def".equals(attributeName)) {
          readInDef(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInIn(JsonReader in, ImmutableHasNullable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = inTypeAdapter.read(in);
        builder.in(value);
      }
    }

    private void readInDef(JsonReader in, ImmutableHasNullable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        builder.def(null);
      } else {
        builder.def(in.nextString());
      }
    }
  }
}
