package nonimmutables.shallow.deep;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractCharlie}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCharlie.builder()}.
 */
@Generated(from = "AbstractCharlie", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableCharlie extends AbstractCharlie {

  private ImmutableCharlie(ImmutableCharlie.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCharlie} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCharlie
        && equalTo(0, (ImmutableCharlie) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableCharlie another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1224276407;
  }

  /**
   * Prints the immutable value {@code Charlie}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Charlie{}";
  }

  /**
   * Creates an immutable copy of a {@link AbstractCharlie} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Charlie instance
   */
  public static ImmutableCharlie copyOf(AbstractCharlie instance) {
    if (instance instanceof ImmutableCharlie) {
      return (ImmutableCharlie) instance;
    }
    return ImmutableCharlie.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCharlie ImmutableCharlie}.
   * <pre>
   * ImmutableCharlie.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableCharlie builder
   */
  public static ImmutableCharlie.Builder builder() {
    return new ImmutableCharlie.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCharlie ImmutableCharlie}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractCharlie", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractCharlie} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractCharlie instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableCharlie ImmutableCharlie}.
     * @return An immutable instance of Charlie
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCharlie build() {
      return new ImmutableCharlie(this);
    }
  }
}
