package nonimmutables.alpha;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.bravo.ImmutableFoo;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Outer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOuter.builder()}.
 */
@Generated(from = "Outer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOuter implements Outer {
  private final ImmutableFoo start;
  private final ImmutableFoo finish;

  private ImmutableOuter(ImmutableFoo start, ImmutableFoo finish) {
    this.start = start;
    this.finish = finish;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public ImmutableFoo getStart() {
    return start;
  }

  /**
   * @return The value of the {@code finish} attribute
   */
  @Override
  public ImmutableFoo getFinish() {
    return finish;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Outer#getStart() start} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOuter withStart(ImmutableFoo value) {
    if (this.start == value) return this;
    ImmutableFoo newValue = Objects.requireNonNull(value, "start");
    return new ImmutableOuter(newValue, this.finish);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Outer#getFinish() finish} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for finish
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOuter withFinish(ImmutableFoo value) {
    if (this.finish == value) return this;
    ImmutableFoo newValue = Objects.requireNonNull(value, "finish");
    return new ImmutableOuter(this.start, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOuter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOuter
        && equalTo(0, (ImmutableOuter) another);
  }

  private boolean equalTo(int synthetic, ImmutableOuter another) {
    return start.equals(another.start)
        && finish.equals(another.finish);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code finish}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + start.hashCode();
    h += (h << 5) + finish.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Outer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Outer")
        .omitNullValues()
        .add("start", start)
        .add("finish", finish)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Outer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Outer instance
   */
  public static ImmutableOuter copyOf(Outer instance) {
    if (instance instanceof ImmutableOuter) {
      return (ImmutableOuter) instance;
    }
    return ImmutableOuter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOuter ImmutableOuter}.
   * <pre>
   * ImmutableOuter.builder()
   *    .start(nonimmutables.bravo.ImmutableFoo) // required {@link Outer#getStart() start}
   *    .finish(nonimmutables.bravo.ImmutableFoo) // required {@link Outer#getFinish() finish}
   *    .build();
   * </pre>
   * @return A new ImmutableOuter builder
   */
  public static ImmutableOuter.Builder builder() {
    return new ImmutableOuter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOuter ImmutableOuter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Outer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_START = 0x1L;
    private static final long INIT_BIT_FINISH = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ImmutableFoo start;
    private @Nullable ImmutableFoo finish;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Outer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Outer instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.getStart());
      finish(instance.getFinish());
      return this;
    }

    /**
     * Initializes the value for the {@link Outer#getStart() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder start(ImmutableFoo start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Initializes the value for the {@link Outer#getFinish() finish} attribute.
     * @param finish The value for finish 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder finish(ImmutableFoo finish) {
      this.finish = Objects.requireNonNull(finish, "finish");
      initBits &= ~INIT_BIT_FINISH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOuter ImmutableOuter}.
     * @return An immutable instance of Outer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOuter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOuter(start, finish);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      if ((initBits & INIT_BIT_FINISH) != 0) attributes.add("finish");
      return "Cannot build Outer, some of required attributes are not set " + attributes;
    }
  }
}
