//-no-import-rewrite
package nonimmutables;

import java.lang.Object;
import java.lang.String;
import java.lang.Float;
import java.lang.Double;

/**
 * Immutable implementation of {@link WithCapitalizedAttributes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWithCapitalizedAttributes.builder()}.
 */
@org.immutables.value.Generated(from = "WithCapitalizedAttributes", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@javax.annotation.concurrent.Immutable
@javax.annotation.CheckReturnValue
public final class ImmutableWithCapitalizedAttributes implements nonimmutables.WithCapitalizedAttributes {
  private final int Id;
  private final java.lang.String Name;

  private ImmutableWithCapitalizedAttributes(int Id, java.lang.String Name) {
    this.Id = Id;
    this.Name = Name;
  }

  /**
   * @return The value of the {@code Id} attribute
   */
  @Override
  public int Id() {
    return Id;
  }

  /**
   * @return The value of the {@code Name} attribute
   */
  @Override
  public java.lang.String Name() {
    return Name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithCapitalizedAttributes#Id() Id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for Id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithCapitalizedAttributes withId(int value) {
    if (this.Id == value) return this;
    return new ImmutableWithCapitalizedAttributes(value, this.Name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithCapitalizedAttributes#Name() Name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for Name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithCapitalizedAttributes withName(java.lang.String value) {
    java.lang.String newValue = java.util.Objects.requireNonNull(value, "Name");
    if (this.Name.equals(newValue)) return this;
    return new ImmutableWithCapitalizedAttributes(this.Id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWithCapitalizedAttributes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWithCapitalizedAttributes
        && equalTo(0, (ImmutableWithCapitalizedAttributes) another);
  }

  private boolean equalTo(int synthetic, ImmutableWithCapitalizedAttributes another) {
    return Id == another.Id
        && Name.equals(another.Name);
  }

  /**
   * Computes a hash code from attributes: {@code Id}, {@code Name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @com.google.errorprone.annotations.Var int h = 5381;
    h += (h << 5) + Id;
    h += (h << 5) + Name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WithCapitalizedAttributes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return com.google.common.base.MoreObjects.toStringHelper("WithCapitalizedAttributes")
        .omitNullValues()
        .add("Id", Id)
        .add("Name", Name)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WithCapitalizedAttributes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WithCapitalizedAttributes instance
   */
  public static ImmutableWithCapitalizedAttributes copyOf(WithCapitalizedAttributes instance) {
    if (instance instanceof ImmutableWithCapitalizedAttributes) {
      return (ImmutableWithCapitalizedAttributes) instance;
    }
    return ImmutableWithCapitalizedAttributes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWithCapitalizedAttributes ImmutableWithCapitalizedAttributes}.
   * <pre>
   * ImmutableWithCapitalizedAttributes.builder()
   *    .Id(int) // required {@link WithCapitalizedAttributes#Id() Id}
   *    .Name(String) // required {@link WithCapitalizedAttributes#Name() Name}
   *    .build();
   * </pre>
   * @return A new ImmutableWithCapitalizedAttributes builder
   */
  public static ImmutableWithCapitalizedAttributes.Builder builder() {
    return new ImmutableWithCapitalizedAttributes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWithCapitalizedAttributes ImmutableWithCapitalizedAttributes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @org.immutables.value.Generated(from = "WithCapitalizedAttributes", generator = "Immutables")
  @javax.annotation.concurrent.NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private int Id;
    private @javax.annotation.Nullable java.lang.String Name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WithCapitalizedAttributes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @com.google.errorprone.annotations.CanIgnoreReturnValue 
    public final Builder from(WithCapitalizedAttributes instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      Id(instance.Id());
      Name(instance.Name());
      return this;
    }

    /**
     * Initializes the value for the {@link WithCapitalizedAttributes#Id() Id} attribute.
     * @param Id The value for Id 
     * @return {@code this} builder for use in a chained invocation
     */
    @com.google.errorprone.annotations.CanIgnoreReturnValue 
    public final Builder Id(int Id) {
      this.Id = Id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link WithCapitalizedAttributes#Name() Name} attribute.
     * @param Name The value for Name 
     * @return {@code this} builder for use in a chained invocation
     */
    @com.google.errorprone.annotations.CanIgnoreReturnValue 
    public final Builder Name(java.lang.String Name) {
      this.Name = java.util.Objects.requireNonNull(Name, "Name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWithCapitalizedAttributes ImmutableWithCapitalizedAttributes}.
     * @return An immutable instance of WithCapitalizedAttributes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWithCapitalizedAttributes build() {
      if (initBits != 0) {
        throw new java.lang.IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWithCapitalizedAttributes(Id, Name);
    }

    private String formatRequiredAttributesMessage() {
      java.util.List<String> attributes = new java.util.ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("Id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("Name");
      return "Cannot build WithCapitalizedAttributes, some of required attributes are not set " + attributes;
    }
  }
}
