package nonimmutables;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Type}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableType.builder()}.
 */
@Generated(from = "Type", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableType extends Type {

  private ImmutableType(ImmutableType.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableType
        && equalTo(0, (ImmutableType) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableType another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1210794583;
  }

  /**
   * Prints the immutable value {@code Type}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Type{}";
  }

  /**
   * Creates an immutable copy of a {@link Type} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Type instance
   */
  public static ImmutableType copyOf(Type instance) {
    if (instance instanceof ImmutableType) {
      return (ImmutableType) instance;
    }
    return ImmutableType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableType ImmutableType}.
   * <pre>
   * ImmutableType.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableType builder
   */
  public static ImmutableType.Builder builder() {
    return new ImmutableType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableType ImmutableType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Type", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Type} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Type instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableType ImmutableType}.
     * @return An immutable instance of Type
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableType build() {
      return new ImmutableType(this);
    }
  }
}
