package nonimmutables;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Type.Nested.Deeper.Deepest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeepest.builder()}.
 */
@Generated(from = "Type.Nested.Deeper.Deepest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDeepest implements Type.Nested.Deeper.Deepest {

  private ImmutableDeepest(ImmutableDeepest.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeepest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeepest
        && equalTo(0, (ImmutableDeepest) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableDeepest another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 87022391;
  }

  /**
   * Prints the immutable value {@code Deepest}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Deepest{}";
  }

  /**
   * Creates an immutable copy of a {@link Type.Nested.Deeper.Deepest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Deepest instance
   */
  public static ImmutableDeepest copyOf(Type.Nested.Deeper.Deepest instance) {
    if (instance instanceof ImmutableDeepest) {
      return (ImmutableDeepest) instance;
    }
    return ImmutableDeepest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeepest ImmutableDeepest}.
   * <pre>
   * ImmutableDeepest.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableDeepest builder
   */
  public static ImmutableDeepest.Builder builder() {
    return new ImmutableDeepest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeepest ImmutableDeepest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Type.Nested.Deeper.Deepest", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Deepest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Type.Nested.Deeper.Deepest instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeepest ImmutableDeepest}.
     * @return An immutable instance of Deepest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeepest build() {
      return new ImmutableDeepest(this);
    }
  }
}
