package borg.immutables.fixture.packoutput.impl;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.packoutput.Packs;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link org.immutables.fixture.packoutput.Packs}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePacks.builder()}.
 */
@Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePacks extends Packs {
  private final Packs.Perk perk;

  private ImmutablePacks(Packs.Perk perk) {
    this.perk = perk;
  }

  /**
   * @return The value of the {@code perk} attribute
   */
  @Override
  public Packs.Perk perk() {
    return perk;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link org.immutables.fixture.packoutput.Packs#perk() perk} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for perk
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePacks withPerk(Packs.Perk value) {
    if (this.perk == value) return this;
    Packs.Perk newValue = Objects.requireNonNull(value, "perk");
    return new ImmutablePacks(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePacks} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePacks
        && equalTo(0, (ImmutablePacks) another);
  }

  private boolean equalTo(int synthetic, ImmutablePacks another) {
    return perk.equals(another.perk);
  }

  /**
   * Computes a hash code from attributes: {@code perk}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + perk.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Packs} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Packs")
        .omitNullValues()
        .add("perk", perk)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link org.immutables.fixture.packoutput.Packs} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Packs instance
   */
  public static ImmutablePacks copyOf(Packs instance) {
    if (instance instanceof ImmutablePacks) {
      return (ImmutablePacks) instance;
    }
    return ImmutablePacks.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePacks ImmutablePacks}.
   * <pre>
   * ImmutablePacks.builder()
   *    .perk(org.immutables.fixture.packoutput.Packs.Perk) // required {@link org.immutables.fixture.packoutput.Packs#perk() perk}
   *    .build();
   * </pre>
   * @return A new ImmutablePacks builder
   */
  public static ImmutablePacks.Builder builder() {
    return new ImmutablePacks.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePacks ImmutablePacks}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PERK = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Packs.Perk perk;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Packs} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Packs instance) {
      Objects.requireNonNull(instance, "instance");
      perk(instance.perk());
      return this;
    }

    /**
     * Initializes the value for the {@link org.immutables.fixture.packoutput.Packs#perk() perk} attribute.
     * @param perk The value for perk 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder perk(Packs.Perk perk) {
      this.perk = Objects.requireNonNull(perk, "perk");
      initBits &= ~INIT_BIT_PERK;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePacks ImmutablePacks}.
     * @return An immutable instance of Packs
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePacks build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePacks(perk);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PERK) != 0) attributes.add("perk");
      return "Cannot build Packs, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link org.immutables.fixture.packoutput.Packs.Perk}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutablePacks.Perk.builder()}.
   */
  @Generated(from = "org.immutables.fixture.packoutput.Packs.Perk", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Perk implements Packs.Perk {

    private Perk(ImmutablePacks.Perk.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code Perk} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutablePacks.Perk
          && equalTo(0, (ImmutablePacks.Perk) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, ImmutablePacks.Perk another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 1646885117;
    }

    /**
     * Prints the immutable value {@code Perk}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Perk{}";
    }

    /**
     * Creates an immutable copy of a {@link org.immutables.fixture.packoutput.Packs.Perk} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Perk instance
     */
    public static ImmutablePacks.Perk copyOf(Packs.Perk instance) {
      if (instance instanceof ImmutablePacks.Perk) {
        return (ImmutablePacks.Perk) instance;
      }
      return ImmutablePacks.Perk.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutablePacks.Perk Perk}.
     * <pre>
     * ImmutablePacks.Perk.builder()
     *    .build();
     * </pre>
     * @return A new Perk builder
     */
    public static ImmutablePacks.Perk.Builder builder() {
      return new ImmutablePacks.Perk.Builder();
    }

    /**
     * Builds instances of type {@link ImmutablePacks.Perk Perk}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "org.immutables.fixture.packoutput.Packs.Perk", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Perk} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Packs.Perk instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutablePacks.Perk Perk}.
       * @return An immutable instance of Perk
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutablePacks.Perk build() {
        return new ImmutablePacks.Perk(this);
      }
    }
  }
}
