/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.metainf.retrofit.processor;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.immutables.metainf.retrofit.;
import org.immutables.metainf.retrofit.$generator$.$AbstractTemplate;
import org.immutables.metainf.retrofit.$generator$.$AnnotationMirrors;
import org.immutables.metainf.retrofit.$generator$.$TypeHierarchyCollector;
import org.immutables.metainf.retrofit.$guava$.collect.$FluentIterable;
import org.immutables.metainf.retrofit.$guava$.collect.$ImmutableList;
import org.immutables.metainf.retrofit.$guava$.collect.$ImmutableListMultimap;
import org.immutables.metainf.retrofit.$guava$.collect.$ListMultimap;
import org.immutables.metainf.retrofit.$guava$.collect.$Lists;
import org.immutables.metainf.retrofit.Metainf;

@.generator..Generator.Template
class Metaservices
extends $AbstractTemplate {
    Metaservices() {
    }

    $ListMultimap<String, String> allMetaservices() {
        $ImmutableListMultimap.Builder builder = $ImmutableListMultimap.builder();
        for (Element element : this.round().getElementsAnnotatedWith(Metainf.Service.class)) {
            TypeElement typeElement = this.validated(element);
            if (typeElement == null) continue;
            Set<String> interfaceNames = this.extractServiceInterfaceNames(typeElement);
            builder.putAll((Object)typeElement.getQualifiedName().toString(), interfaceNames);
        }
        return builder.build();
    }

    private Set<String> extractServiceInterfaceNames(TypeElement typeElement) {
        $ImmutableList<TypeMirror> typesMirrors = $AnnotationMirrors.getTypesFromMirrors(Metainf.Service.class.getCanonicalName(), "value", typeElement.getAnnotationMirrors());
        if (typesMirrors.isEmpty()) {
            return this.useIntrospectedInterfacesForServices(typeElement);
        }
        return this.useProvidedTypesForServices(typeElement, typesMirrors);
    }

    private Set<String> useIntrospectedInterfacesForServices(TypeElement typeElement) {
        $TypeHierarchyCollector typeHierarchyCollector = new $TypeHierarchyCollector();
        typeHierarchyCollector.collectFrom(typeElement.asType());
        return typeHierarchyCollector.implementedInterfaceNames();
    }

    private Set<String> useProvidedTypesForServices(TypeElement typeElement, $ImmutableList<TypeMirror> typesMirrors) {
        ArrayList<String> wrongTypes = $Lists.newArrayList();
        ArrayList<String> types = $Lists.newArrayList();
        for (TypeMirror typeMirror : typesMirrors) {
            if (typeMirror.getKind() != TypeKind.DECLARED || !this.processing().getTypeUtils().isAssignable(typeElement.asType(), typeMirror)) {
                wrongTypes.add(typeMirror.toString());
                continue;
            }
            types.add(typeMirror.toString());
        }
        if (!wrongTypes.isEmpty()) {
            this.processing().getMessager().printMessage(Diagnostic.Kind.ERROR, "@Metainf.Service(value = {...}) contains types that are not implemented by " + typeElement.getSimpleName() + ": " + wrongTypes, typeElement, $AnnotationMirrors.findAnnotation(typeElement.getAnnotationMirrors(), Metainf.Service.class));
        }
        return $FluentIterable.from(types).toSet();
    }

    @Nullable
    private TypeElement validated(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        if (element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.ABSTRACT) && enclosingElement != null && enclosingElement.getKind() == ElementKind.PACKAGE && !((PackageElement)enclosingElement).isUnnamed()) {
            return (TypeElement)element;
        }
        this.processing().getMessager().printMessage(Diagnostic.Kind.ERROR, "Element annotated with @Metainf.Service annotation should be public top-level non-abstract class in a package", element);
        return null;
    }
}

