package org.immutables.criteria.geode;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GeodeSetup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new GeodeSetup.Builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableGeodeSetup.of()}.
 */
@Generated(from = "GeodeSetup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableGeodeSetup implements GeodeSetup {
  private final RegionResolver regionResolver;
  private final KeyExtractor.Factory keyExtractorFactory;
  private final QueryServiceResolver queryServiceResolver;

  private ImmutableGeodeSetup(RegionResolver regionResolver) {
    this.regionResolver = Objects.requireNonNull(regionResolver, "regionResolver");
    this.keyExtractorFactory = initShim.keyExtractorFactory();
    this.queryServiceResolver = initShim.queryServiceResolver();
    this.initShim = null;
  }

  private ImmutableGeodeSetup(ImmutableGeodeSetup.Builder builder) {
    this.regionResolver = builder.regionResolver;
    if (builder.keyExtractorFactory != null) {
      initShim.keyExtractorFactory(builder.keyExtractorFactory);
    }
    if (builder.queryServiceResolver != null) {
      initShim.queryServiceResolver(builder.queryServiceResolver);
    }
    this.keyExtractorFactory = initShim.keyExtractorFactory();
    this.queryServiceResolver = initShim.queryServiceResolver();
    this.initShim = null;
  }

  private ImmutableGeodeSetup(
      RegionResolver regionResolver,
      KeyExtractor.Factory keyExtractorFactory,
      QueryServiceResolver queryServiceResolver) {
    this.regionResolver = regionResolver;
    this.keyExtractorFactory = keyExtractorFactory;
    this.queryServiceResolver = queryServiceResolver;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GeodeSetup", generator = "Immutables")
  private final class InitShim {
    private byte keyExtractorFactoryBuildStage = STAGE_UNINITIALIZED;
    private KeyExtractor.Factory keyExtractorFactory;

    KeyExtractor.Factory keyExtractorFactory() {
      if (keyExtractorFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (keyExtractorFactoryBuildStage == STAGE_UNINITIALIZED) {
        keyExtractorFactoryBuildStage = STAGE_INITIALIZING;
        this.keyExtractorFactory = Objects.requireNonNull(keyExtractorFactoryInitialize(), "keyExtractorFactory");
        keyExtractorFactoryBuildStage = STAGE_INITIALIZED;
      }
      return this.keyExtractorFactory;
    }

    void keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
      this.keyExtractorFactory = keyExtractorFactory;
      keyExtractorFactoryBuildStage = STAGE_INITIALIZED;
    }

    private byte queryServiceResolverBuildStage = STAGE_UNINITIALIZED;
    private QueryServiceResolver queryServiceResolver;

    QueryServiceResolver queryServiceResolver() {
      if (queryServiceResolverBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (queryServiceResolverBuildStage == STAGE_UNINITIALIZED) {
        queryServiceResolverBuildStage = STAGE_INITIALIZING;
        this.queryServiceResolver = Objects.requireNonNull(queryServiceResolverInitialize(), "queryServiceResolver");
        queryServiceResolverBuildStage = STAGE_INITIALIZED;
      }
      return this.queryServiceResolver;
    }

    void queryServiceResolver(QueryServiceResolver queryServiceResolver) {
      this.queryServiceResolver = queryServiceResolver;
      queryServiceResolverBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (keyExtractorFactoryBuildStage == STAGE_INITIALIZING) attributes.add("keyExtractorFactory");
      if (queryServiceResolverBuildStage == STAGE_INITIALIZING) attributes.add("queryServiceResolver");
      return "Cannot build GeodeSetup, attribute initializers form cycle " + attributes;
    }
  }

  private KeyExtractor.Factory keyExtractorFactoryInitialize() {
    return GeodeSetup.super.keyExtractorFactory();
  }

  private QueryServiceResolver queryServiceResolverInitialize() {
    return GeodeSetup.super.queryServiceResolver();
  }

  /**
   * @return The value of the {@code regionResolver} attribute
   */
  @Override
  public RegionResolver regionResolver() {
    return regionResolver;
  }

  /**
   * @return The value of the {@code keyExtractorFactory} attribute
   */
  @Override
  public KeyExtractor.Factory keyExtractorFactory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.keyExtractorFactory()
        : this.keyExtractorFactory;
  }

  /**
   * @return The value of the {@code queryServiceResolver} attribute
   */
  @Override
  public QueryServiceResolver queryServiceResolver() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.queryServiceResolver()
        : this.queryServiceResolver;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeodeSetup#regionResolver() regionResolver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for regionResolver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeodeSetup withRegionResolver(RegionResolver value) {
    if (this.regionResolver == value) return this;
    RegionResolver newValue = Objects.requireNonNull(value, "regionResolver");
    return new ImmutableGeodeSetup(newValue, this.keyExtractorFactory, this.queryServiceResolver);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeodeSetup#keyExtractorFactory() keyExtractorFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyExtractorFactory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeodeSetup withKeyExtractorFactory(KeyExtractor.Factory value) {
    if (this.keyExtractorFactory == value) return this;
    KeyExtractor.Factory newValue = Objects.requireNonNull(value, "keyExtractorFactory");
    return new ImmutableGeodeSetup(this.regionResolver, newValue, this.queryServiceResolver);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeodeSetup#queryServiceResolver() queryServiceResolver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for queryServiceResolver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeodeSetup withQueryServiceResolver(QueryServiceResolver value) {
    if (this.queryServiceResolver == value) return this;
    QueryServiceResolver newValue = Objects.requireNonNull(value, "queryServiceResolver");
    return new ImmutableGeodeSetup(this.regionResolver, this.keyExtractorFactory, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGeodeSetup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGeodeSetup
        && equalTo(0, (ImmutableGeodeSetup) another);
  }

  private boolean equalTo(int synthetic, ImmutableGeodeSetup another) {
    return regionResolver.equals(another.regionResolver)
        && keyExtractorFactory.equals(another.keyExtractorFactory)
        && queryServiceResolver.equals(another.queryServiceResolver);
  }

  /**
   * Computes a hash code from attributes: {@code regionResolver}, {@code keyExtractorFactory}, {@code queryServiceResolver}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + regionResolver.hashCode();
    h += (h << 5) + keyExtractorFactory.hashCode();
    h += (h << 5) + queryServiceResolver.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GeodeSetup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GeodeSetup")
        .omitNullValues()
        .add("regionResolver", regionResolver)
        .add("keyExtractorFactory", keyExtractorFactory)
        .add("queryServiceResolver", queryServiceResolver)
        .toString();
  }

  /**
   * Construct a new immutable {@code GeodeSetup} instance.
   * @param regionResolver The value for the {@code regionResolver} attribute
   * @return An immutable GeodeSetup instance
   */
  public static ImmutableGeodeSetup of(RegionResolver regionResolver) {
    return new ImmutableGeodeSetup(regionResolver);
  }

  /**
   * Creates an immutable copy of a {@link GeodeSetup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GeodeSetup instance
   */
  public static ImmutableGeodeSetup copyOf(GeodeSetup instance) {
    if (instance instanceof ImmutableGeodeSetup) {
      return (ImmutableGeodeSetup) instance;
    }
    return new GeodeSetup.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableGeodeSetup ImmutableGeodeSetup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GeodeSetup", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_REGION_RESOLVER = 0x1L;
    private long initBits = 0x1L;

    private @Nullable RegionResolver regionResolver;
    private @Nullable KeyExtractor.Factory keyExtractorFactory;
    private @Nullable QueryServiceResolver queryServiceResolver;

    /**
     * Creates a builder for {@link ImmutableGeodeSetup ImmutableGeodeSetup} instances.
     * <pre>
     * new GeodeSetup.Builder()
     *    .regionResolver(org.immutables.criteria.geode.RegionResolver) // required {@link GeodeSetup#regionResolver() regionResolver}
     *    .keyExtractorFactory(org.immutables.criteria.backend.KeyExtractor.Factory) // optional {@link GeodeSetup#keyExtractorFactory() keyExtractorFactory}
     *    .queryServiceResolver(org.immutables.criteria.geode.QueryServiceResolver) // optional {@link GeodeSetup#queryServiceResolver() queryServiceResolver}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof GeodeSetup.Builder)) {
        throw new UnsupportedOperationException("Use: new GeodeSetup.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code GeodeSetup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GeodeSetup.Builder from(GeodeSetup instance) {
      Objects.requireNonNull(instance, "instance");
      regionResolver(instance.regionResolver());
      keyExtractorFactory(instance.keyExtractorFactory());
      queryServiceResolver(instance.queryServiceResolver());
      return (GeodeSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link GeodeSetup#regionResolver() regionResolver} attribute.
     * @param regionResolver The value for regionResolver 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GeodeSetup.Builder regionResolver(RegionResolver regionResolver) {
      this.regionResolver = Objects.requireNonNull(regionResolver, "regionResolver");
      initBits &= ~INIT_BIT_REGION_RESOLVER;
      return (GeodeSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link GeodeSetup#keyExtractorFactory() keyExtractorFactory} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GeodeSetup#keyExtractorFactory() keyExtractorFactory}.</em>
     * @param keyExtractorFactory The value for keyExtractorFactory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GeodeSetup.Builder keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
      this.keyExtractorFactory = Objects.requireNonNull(keyExtractorFactory, "keyExtractorFactory");
      return (GeodeSetup.Builder) this;
    }

    /**
     * Initializes the value for the {@link GeodeSetup#queryServiceResolver() queryServiceResolver} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GeodeSetup#queryServiceResolver() queryServiceResolver}.</em>
     * @param queryServiceResolver The value for queryServiceResolver 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GeodeSetup.Builder queryServiceResolver(QueryServiceResolver queryServiceResolver) {
      this.queryServiceResolver = Objects.requireNonNull(queryServiceResolver, "queryServiceResolver");
      return (GeodeSetup.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableGeodeSetup ImmutableGeodeSetup}.
     * @return An immutable instance of GeodeSetup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGeodeSetup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGeodeSetup(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REGION_RESOLVER) != 0) attributes.add("regionResolver");
      return "Cannot build GeodeSetup, some of required attributes are not set " + attributes;
    }
  }
}
