/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.elasticsearch.JsonConverter;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;

class ToTupleConverter
implements JsonConverter<ProjectedTuple> {
    private final Query query;
    private final List<ProjectedField> fields;

    ToTupleConverter(Query query, ObjectMapper mapper) {
        Preconditions.checkArgument((boolean)query.hasProjections(), (Object)"no projections defined");
        this.query = query;
        this.fields = query.projections().stream().map(e -> new ProjectedField((Expression)e, mapper)).collect(Collectors.toList());
    }

    @Override
    public ProjectedTuple convert(JsonNode node) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (ProjectedField info : this.fields) {
            JsonNode value = node.path(info.pathAsString);
            if (value.isMissingNode()) {
                value = NullNode.getInstance();
            }
            values.add(info.convert(value));
        }
        return ProjectedTuple.of((Iterable)this.query.projections(), values);
    }

    private static class ProjectedField {
        private final Path path;
        private final String pathAsString;
        private final JavaType javaType;
        private final ObjectMapper mapper;

        private ProjectedField(Expression expr, ObjectMapper mapper) {
            Path path;
            this.path = path = (Path)expr;
            this.mapper = mapper;
            this.pathAsString = path.toStringPath();
            this.javaType = mapper.getTypeFactory().constructType(path.returnType());
        }

        Object convert(JsonNode json) {
            return this.mapper.convertValue((Object)json, this.javaType);
        }
    }
}

