/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import io.reactivex.Single;
import java.util.Objects;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;

class RxJavaTransport {
    private final RestClient restClient;

    RxJavaTransport(RestClient restClient) {
        this.restClient = Objects.requireNonNull(restClient, "restClient");
    }

    Single<Response> execute(Request request) {
        Objects.requireNonNull(request, "request");
        return Single.create(source -> this.restClient.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                source.onSuccess((Object)response);
            }

            public void onFailure(Exception exception) {
                source.onError((Throwable)exception);
            }
        }));
    }
}

