/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.elasticsearch.Json;
import org.immutables.criteria.elasticsearch.Mapping;
import org.immutables.criteria.elasticsearch.RxJavaTransport;
import org.immutables.criteria.elasticsearch.Version;

class IndexOps {
    private final RxJavaTransport transport;
    private final ObjectMapper mapper;
    private final String index;

    IndexOps(RestClient restClient, ObjectMapper mapper, String index) {
        this.transport = new RxJavaTransport(restClient);
        this.mapper = mapper;
        this.index = Objects.requireNonNull(index, "index");
    }

    Single<Boolean> exists() {
        String uri = String.format(Locale.ROOT, "/%s/_mapping", this.index);
        Request request = new Request("GET", uri);
        return this.transport.execute(request).map(x -> true).onErrorResumeNext(e -> Single.just((Object)false));
    }

    Single<Mapping> mapping() {
        String uri = String.format(Locale.ROOT, "/%s/_mapping", this.index);
        Request request = new Request("GET", uri);
        return this.transport.execute(request).map(response -> (ObjectNode)this.mapper.readValue(response.getEntity().getContent(), ObjectNode.class)).map(root -> {
            ObjectNode properties = (ObjectNode)((JsonNode)root.elements().next()).get("mappings");
            if (properties == null) {
                throw new IllegalStateException(String.format("No mappings found for index %s (after request %s)", this.index, request));
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Json.visitMappingProperties(properties, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
            return Mapping.ofElastic((Map<String, String>)builder.build());
        });
    }

    Single<Version> version() {
        Request request = new Request("GET", "/");
        Function<ObjectNode, Version> fn = node -> Version.of(node.get("version").get("number").asText());
        return this.transport.execute(request).map(response -> (ObjectNode)this.mapper.readValue(response.getEntity().getContent(), ObjectNode.class)).map(fn::apply);
    }

    Completable create(Mapping mapping) {
        Objects.requireNonNull(mapping, "mapping");
        Map<String, String> newMap = mapping.fields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Mapping.Datatype)e.getValue()).name()));
        return this.create(newMap);
    }

    Completable create(Map<String, String> mapping) {
        Objects.requireNonNull(mapping, "mapping");
        ObjectNode mappings = this.mapper.createObjectNode();
        ObjectNode properties = mappings.with("mappings").with("properties");
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            IndexOps.applyMapping(properties, entry.getKey(), entry.getValue());
        }
        try {
            StringEntity entity = new StringEntity(this.mapper.writeValueAsString((Object)mappings), ContentType.APPLICATION_JSON);
            Request r = new Request("PUT", "/" + this.index);
            r.setEntity((HttpEntity)entity);
            return this.transport.execute(r).ignoreElement();
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private static void applyMapping(ObjectNode parent, String key, String type) {
        int index = key.indexOf(46);
        if (index > -1) {
            String prefix = key.substring(0, index);
            String suffix = key.substring(index + 1);
            IndexOps.applyMapping(parent.with(prefix).with("properties"), suffix, type);
        } else {
            parent.with(key).put("type", type);
        }
    }

    Completable delete() {
        Request r = new Request("DELETE", "/" + this.index);
        return this.transport.execute(r).ignoreElement();
    }
}

