/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.reactivex.Single;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.elasticsearch.Elasticsearch;
import org.immutables.criteria.elasticsearch.ElasticsearchBackend;
import org.immutables.criteria.elasticsearch.Json;
import org.immutables.criteria.expression.Query;

class CountCall
implements Callable<Single<Long>> {
    private final StandardOperations.Select operation;
    private final ElasticsearchBackend.Session session;

    CountCall(StandardOperations.Select operation, ElasticsearchBackend.Session session) {
        this.operation = operation;
        this.session = session;
    }

    @Override
    public Single<Long> call() {
        Query query = this.operation.query();
        if (query.count() && (query.hasAggregations() || !query.groupBy().isEmpty())) {
            throw new UnsupportedOperationException("count(*) doesn't work with existing aggregates");
        }
        if (query.offset().isPresent()) {
            throw new UnsupportedOperationException(String.format("count(*) with offset not supported in %s", ElasticsearchBackend.class.getSimpleName()));
        }
        OptionalLong limit = query.limit();
        if (limit.isPresent() && limit.getAsLong() <= 0L) {
            return Single.just((Object)0L);
        }
        ObjectNode filter = query.filter().map(f -> Elasticsearch.toBuilder(f, this.session.pathNaming, this.session.idPredicate).toJson(this.session.objectMapper)).orElse(this.session.objectMapper.createObjectNode());
        if (filter.size() != 0) {
            filter = (ObjectNode)this.session.objectMapper.createObjectNode().set("query", (JsonNode)filter);
        }
        return this.session.ops.count(filter).map(Json.Count::count).map(count -> limit.isPresent() ? Math.min(limit.getAsLong(), count) : count);
    }
}

