/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.sample.genericTechDrivenPriceSrc.tech;

import java.util.ArrayList;
import java.util.List;
import org.ikasan.sample.genericTechDrivenPriceSrc.tech.PriceTechListener;
import org.ikasan.sample.genericTechDrivenPriceSrc.tech.PriceTechMessage;

public class PriceTechImpl
implements Runnable {
    private PriceTechListener priceTechListener;
    private long loop = 1000L;
    boolean active = true;
    boolean deliver = false;
    boolean executed = false;
    List<PriceTechMessage> priceTechMessages;

    public PriceTechImpl() {
        this.priceTechMessages = new ArrayList<PriceTechMessage>();
        this.priceTechMessages.add(new PriceTechMessage("sample", 10, 10));
    }

    public PriceTechImpl(List<PriceTechMessage> priceTechMessages) {
        this.priceTechMessages = priceTechMessages;
        if (priceTechMessages == null) {
            throw new IllegalArgumentException("priceTechMessages cannot be 'null'");
        }
    }

    public void setListener(PriceTechListener priceTechListener) {
        this.priceTechListener = priceTechListener;
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                while (this.deliver & !this.executed) {
                    for (PriceTechMessage priceTechMessage : this.priceTechMessages) {
                        this.priceTechListener.onPrice(priceTechMessage);
                    }
                    this.executed = true;
                }
                Thread.sleep(this.loop);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void startDelivery() {
        this.deliver = true;
        this.executed = false;
    }

    public void stopDelivery() {
        this.deliver = false;
    }

    public boolean isRunning() {
        return this.deliver;
    }

    public void shutdown() {
        this.stopDelivery();
        this.active = false;
    }

    private void pause(long period) {
        try {
            Thread.sleep(period);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

