/* 
 * $Id$
 * $URL$
 *
 * ====================================================================
 * Ikasan Enterprise Integration Platform
 * 
 * Distributed under the Modified BSD License.
 * Copyright notice: The copyright for this software and a full listing 
 * of individual contributors are as shown in the packaged copyright.txt 
 * file. 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of the ORGANIZATION nor the names of its contributors may
 *    be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */
package org.ikasan.sample.genericTechDrivenPriceSrc.component.converter;

import org.ikasan.sample.genericTechDrivenPriceSrc.tech.PriceTechMessage;
import org.ikasan.spec.component.transformation.Converter;
import org.ikasan.spec.component.transformation.TransformationException;
import org.ikasan.spec.flow.FlowElementInvocation;
import org.ikasan.spec.flow.InvocationAware;

/**
 * Implementation of a converter to convert price tech message into a
 * StringBuilder object.
 * 
 * @author Ikasan Development Team
 */
public class PriceConverter<ID, METRIC> implements Converter<PriceTechMessage,StringBuilder>, InvocationAware<ID,METRIC>
{
    private FlowElementInvocation<?,?> flowElementInvocation;

    public StringBuilder convert(PriceTechMessage price) throws TransformationException
    {
        StringBuilder sb = new StringBuilder();
        sb.append("identifier = ");
        sb.append(price.getIdentifier());
        sb.append(" bid = ");
        sb.append(price.getBid());
        sb.append(" spread = ");
        sb.append(price.getSpread());
        sb.append(" at = ");
        sb.append(price.getTime());

        if (flowElementInvocation != null)
        {
            flowElementInvocation.addCustomMetric("CUSTOM", "value");
        }

        return sb;
    }

    /**
     * Sets the flow element invocation
     *
     * @param flowElementInvocation the invocation
     */
    @Override
    public void setFlowElementInvocation(FlowElementInvocation<ID, METRIC> flowElementInvocation)
    {
        this.flowElementInvocation = flowElementInvocation;
    }

    @Override
    public void unsetFlowElementInvocation(FlowElementInvocation<ID, METRIC> flowElementInvocation)
    {
        this.flowElementInvocation = null;
    }
}
