/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.notification.notifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ikasan.job.orchestration.model.notification.EmailNotificationDetailsImpl;
import org.ikasan.job.orchestration.model.notification.GenericNotificationDetails;
import org.ikasan.job.orchestration.model.notification.NotificationType;
import org.ikasan.notification.configuration.EmailNotificationParamsConfiguration;
import org.ikasan.notification.notifier.AbstractEmailNotifierBase;
import org.ikasan.scheduled.notification.model.SolrNotificationSendAudit;
import org.ikasan.scheduled.notification.model.SolrNotificationSendAuditRecord;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationContext;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationContextRecord;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationDetails;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationDetailsRecord;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationTemplateParameters;
import org.ikasan.spec.scheduled.notification.model.NotificationSendAudit;
import org.ikasan.spec.scheduled.notification.model.NotificationSendAuditRecord;
import org.ikasan.spec.scheduled.notification.model.Notifier;
import org.ikasan.spec.scheduled.notification.service.EmailNotificationContextService;
import org.ikasan.spec.scheduled.notification.service.EmailNotificationDetailsService;
import org.ikasan.spec.scheduled.notification.service.NotificationSendAuditService;
import org.ikasan.spec.search.SearchResults;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public class EmailNotifier
extends AbstractEmailNotifierBase
implements Notifier<GenericNotificationDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(EmailNotifier.class);
    private EmailNotificationDetailsService emailNotificationDetailsService;
    private EmailNotificationContextService emailNotificationContextService;
    private NotificationSendAuditService<NotificationSendAuditRecord> notificationSendAuditService;
    private EmailNotificationParamsConfiguration emailNotificationParamsConfiguration;
    private TemplateEngine templateEngine;
    private String mailLinkUrl;

    public EmailNotifier(EmailNotificationDetailsService emailNotificationDetailsService, EmailNotificationContextService emailNotificationContextService, NotificationSendAuditService notificationSendAuditService, EmailNotificationParamsConfiguration emailNotificationParamsConfiguration, TemplateEngine templateEngine, String mailLinkUrl) {
        this.emailNotificationDetailsService = emailNotificationDetailsService;
        this.emailNotificationContextService = emailNotificationContextService;
        this.notificationSendAuditService = notificationSendAuditService;
        this.emailNotificationParamsConfiguration = emailNotificationParamsConfiguration;
        this.templateEngine = templateEngine;
        this.mailLinkUrl = mailLinkUrl;
    }

    public void invoke(GenericNotificationDetails notificationDetails) {
        NotificationSendAuditRecord notificationSendAuditRecord;
        EmailNotificationDetails emailNotificationDetails = null;
        EmailNotificationDetailsRecord emailNotificationDetailsRecord = this.emailNotificationDetailsService.findByJobNameAndMonitorType(notificationDetails.getJobName(), notificationDetails.getChildContextName(), notificationDetails.getMonitorType().name());
        if (emailNotificationDetailsRecord == null) {
            String contextName = notificationDetails.getContextName();
            SearchResults emailNotificationContextRecordSearchResults = this.emailNotificationContextService.findByContextName(contextName, 50, 0);
            if (emailNotificationContextRecordSearchResults != null && emailNotificationContextRecordSearchResults.getResultList() != null && !emailNotificationContextRecordSearchResults.getResultList().isEmpty() && emailNotificationContextRecordSearchResults.getResultList().size() == 1) {
                EmailNotificationContextRecord emailNotificationContextRecord = (EmailNotificationContextRecord)emailNotificationContextRecordSearchResults.getResultList().get(0);
                EmailNotificationContext emailNotificationContext = emailNotificationContextRecord.getEmailNotificationContext();
                boolean foundMonitorType = false;
                if (emailNotificationContext.getMonitorTypes() != null && !emailNotificationContext.getMonitorTypes().isEmpty()) {
                    for (String monitorType : emailNotificationContext.getMonitorTypes()) {
                        if (!monitorType.equals(notificationDetails.getMonitorType().name())) continue;
                        foundMonitorType = true;
                        break;
                    }
                }
                if (foundMonitorType) {
                    emailNotificationDetails = new EmailNotificationDetailsImpl();
                    emailNotificationDetails.setJobName(notificationDetails.getJobName());
                    emailNotificationDetails.setContextName(contextName);
                    emailNotificationDetails.setChildContextName(notificationDetails.getChildContextName());
                    emailNotificationDetails.setMonitorType(notificationDetails.getMonitorType().name());
                    if (emailNotificationContext.getEmailSendToByMonitorType().containsKey(notificationDetails.getMonitorType().name())) {
                        emailNotificationDetails.setEmailSendTo((List)emailNotificationContext.getEmailSendToByMonitorType().get(notificationDetails.getMonitorType().name()));
                    } else {
                        emailNotificationDetails.setEmailSendTo(emailNotificationContext.getEmailSendTo());
                    }
                    if (emailNotificationContext.getEmailSendCcByMonitorType().containsKey(notificationDetails.getMonitorType().name())) {
                        emailNotificationDetails.setEmailSendCc((List)emailNotificationContext.getEmailSendCcByMonitorType().get(notificationDetails.getMonitorType().name()));
                    } else {
                        emailNotificationDetails.setEmailSendCc(emailNotificationContext.getEmailSendCc());
                    }
                    if (emailNotificationContext.getEmailSendBccByMonitorType().containsKey(notificationDetails.getMonitorType().name())) {
                        emailNotificationDetails.setEmailSendBcc((List)emailNotificationContext.getEmailSendBccByMonitorType().get(notificationDetails.getMonitorType().name()));
                    } else {
                        emailNotificationDetails.setEmailSendBcc(emailNotificationContext.getEmailSendBcc());
                    }
                    emailNotificationDetails.setAttachment(emailNotificationContext.getAttachment());
                    emailNotificationDetails.setHtml(emailNotificationContext.isHtml());
                    emailNotificationDetails.setEmailSubjectTemplate((String)emailNotificationContext.getEmailSubjectNotificationTemplate().get(notificationDetails.getMonitorType().name()));
                    emailNotificationDetails.setEmailBodyTemplate((String)emailNotificationContext.getEmailBodyNotificationTemplate().get(notificationDetails.getMonitorType().name()));
                }
            }
        } else {
            emailNotificationDetails = emailNotificationDetailsRecord.getEmailNotificationDetails();
        }
        if (!(emailNotificationDetails == null || (notificationSendAuditRecord = (NotificationSendAuditRecord)this.notificationSendAuditService.find(notificationDetails.getContextInstanceId(), notificationDetails.getChildContextName(), notificationDetails.getJobName(), notificationDetails.getMonitorType().name(), NotificationType.EMAIL.name())) != null && notificationSendAuditRecord.getNotificationSendAudit() != null && notificationSendAuditRecord.getNotificationSendAudit().isNotificationSend())) {
            LOG.info("Email Notification being sent for Context [{}], Child Context [{}], Job Name [{}] and Monitor Type [{}]", new Object[]{emailNotificationDetails.getContextName(), emailNotificationDetails.getChildContextName(), emailNotificationDetails.getJobName(), emailNotificationDetails.getMonitorType()});
            this.parameterReplace(emailNotificationDetails, this.emailNotificationParamsConfiguration);
            Context ctx = new Context();
            ctx.setVariable("emailNotificationDetails", (Object)emailNotificationDetails);
            this.applyEmailNotificationTemplateParameters(emailNotificationDetails, notificationDetails);
            emailNotificationDetails.setEmailBody(this.templateEngine.process(emailNotificationDetails.getEmailBodyTemplate(), (IContext)ctx));
            emailNotificationDetails.setEmailSubject(this.templateEngine.process(emailNotificationDetails.getEmailSubjectTemplate(), (IContext)ctx));
            super.sendEmail(emailNotificationDetails);
            SolrNotificationSendAudit notificationSendAudit = new SolrNotificationSendAudit();
            notificationSendAudit.setContextInstanceId(notificationDetails.getContextInstanceId());
            notificationSendAudit.setJobName(notificationDetails.getJobName());
            notificationSendAudit.setContextName(notificationDetails.getChildContextName());
            notificationSendAudit.setMonitorType(notificationDetails.getMonitorType().name());
            notificationSendAudit.setNotifierType(NotificationType.EMAIL.name());
            notificationSendAudit.setNotificationSend(true);
            SolrNotificationSendAuditRecord record = new SolrNotificationSendAuditRecord();
            record.setNotificationSendAudit((NotificationSendAudit)notificationSendAudit);
            record.setTimestamp(new Date().getTime());
            this.notificationSendAuditService.save((Object)record);
        }
    }

    private void applyEmailNotificationTemplateParameters(EmailNotificationDetails emailNotificationDetails, GenericNotificationDetails notificationDetails) {
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_BODY_LINK_1.name(), this.createMailLink(notificationDetails, false));
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_BODY_LINK_2.name(), this.createMailLink(notificationDetails, true));
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_BODY_MESSAGE_FROM_MONITOR.name(), notificationDetails.getMessage());
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_AGENT_NAME.name(), notificationDetails.getAgentName());
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_CONTEXT_NAME.name(), emailNotificationDetails.getContextName());
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_JOB_NAME.name(), notificationDetails.getJobName());
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_CHILD_CONTEXT.name(), notificationDetails.getChildContextName());
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_FILE_NAME.name(), notificationDetails.getFileName());
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_FILE_PATH.name(), notificationDetails.getFilePath());
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm:ss z");
        emailNotificationDetails.getEmailNotificationTemplateParameters().put(EmailNotificationTemplateParameters.EMAIL_FIRE_TIME.name(), dtf.print(notificationDetails.getFiredTime()));
    }

    private String createMailLink(GenericNotificationDetails notificationDetails, boolean isErrorLog) {
        return this.mailLinkUrl + notificationDetails.getContextInstanceId() + ":::" + notificationDetails.getChildContextName() + ":::" + notificationDetails.getJobName() + ":::" + isErrorLog;
    }

    void parameterReplace(EmailNotificationDetails emailNotificationDetails, EmailNotificationParamsConfiguration emailNotificationParamsConfiguration) {
        Map<String, String> mapOfParamToReplace = emailNotificationParamsConfiguration.getParamsToReplace().get(emailNotificationDetails.getContextName());
        if (mapOfParamToReplace != null && !mapOfParamToReplace.isEmpty()) {
            mapOfParamToReplace.forEach((key, value) -> {
                if (emailNotificationDetails.getEmailNotificationTemplateParameters() != null && !emailNotificationDetails.getEmailNotificationTemplateParameters().isEmpty()) {
                    emailNotificationDetails.getEmailNotificationTemplateParameters().forEach((ke, ve) -> emailNotificationDetails.getEmailNotificationTemplateParameters().put(ke, StringUtils.replace((String)ve, (String)key, (String)value)));
                }
                ArrayList emailSendTo = new ArrayList();
                if (emailNotificationDetails.getEmailSendTo() != null && !emailNotificationDetails.getEmailSendTo().isEmpty()) {
                    emailNotificationDetails.getEmailSendTo().forEach(s -> {
                        if (key.equals(s)) {
                            emailSendTo.addAll(Arrays.asList(value.split(",")));
                        } else {
                            emailSendTo.add(StringUtils.replace((String)s, (String)key, (String)value));
                        }
                    });
                    emailNotificationDetails.setEmailSendTo(emailSendTo);
                }
                ArrayList emailSendCc = new ArrayList();
                if (emailNotificationDetails.getEmailSendCc() != null && !emailNotificationDetails.getEmailSendCc().isEmpty()) {
                    emailNotificationDetails.getEmailSendCc().forEach(s -> {
                        if (key.equals(s)) {
                            emailSendCc.addAll(Arrays.asList(value.split(",")));
                        } else {
                            emailSendCc.add(StringUtils.replace((String)s, (String)key, (String)value));
                        }
                    });
                    emailNotificationDetails.setEmailSendCc(emailSendCc);
                }
                ArrayList emailSendBcc = new ArrayList();
                if (emailNotificationDetails.getEmailSendBcc() != null && !emailNotificationDetails.getEmailSendBcc().isEmpty()) {
                    emailNotificationDetails.getEmailSendBcc().forEach(s -> {
                        if (key.equals(s)) {
                            emailSendBcc.addAll(Arrays.asList(value.split(",")));
                        } else {
                            emailSendBcc.add(StringUtils.replace((String)s, (String)key, (String)value));
                        }
                    });
                    emailNotificationDetails.setEmailSendBcc(emailSendBcc);
                }
                if (StringUtils.isNotBlank((CharSequence)emailNotificationDetails.getEmailSubject())) {
                    emailNotificationDetails.setEmailSubject(StringUtils.replace((String)emailNotificationDetails.getEmailSubject(), (String)key, (String)value));
                }
                if (StringUtils.isNotBlank((CharSequence)emailNotificationDetails.getEmailSubjectTemplate())) {
                    emailNotificationDetails.setEmailSubjectTemplate(StringUtils.replace((String)emailNotificationDetails.getEmailSubjectTemplate(), (String)key, (String)value));
                }
                if (StringUtils.isNotBlank((CharSequence)emailNotificationDetails.getEmailBody())) {
                    emailNotificationDetails.setEmailBody(StringUtils.replace((String)emailNotificationDetails.getEmailBody(), (String)key, (String)value));
                }
                if (StringUtils.isNotBlank((CharSequence)emailNotificationDetails.getEmailBodyTemplate())) {
                    emailNotificationDetails.setEmailBodyTemplate(StringUtils.replace((String)emailNotificationDetails.getEmailBodyTemplate(), (String)key, (String)value));
                }
            });
        }
    }
}

