/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.notification.notifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.ikasan.monitor.notifier.EmailNotifierConfiguration;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmailNotifierBase {
    private static Logger logger = LoggerFactory.getLogger(AbstractEmailNotifierBase.class);
    private static String EMAIL_ADDRESS_SPLIT_REGEXP = ",| |;";
    private EmailNotifierConfiguration configuration;
    private Session session;

    protected void sendEmail(EmailNotificationDetails emailNotificationDetails) {
        MimeMessage message = new MimeMessage(this.session);
        try {
            message.addRecipients(Message.RecipientType.TO, this.toArray(emailNotificationDetails.getEmailSendTo()));
            message.addRecipients(Message.RecipientType.CC, this.toArray(emailNotificationDetails.getEmailSendCc()));
            message.addRecipients(Message.RecipientType.BCC, this.toArray(emailNotificationDetails.getEmailSendBcc()));
            message.setSubject(emailNotificationDetails.getEmailSubject());
            MimeBodyPart bodyPart = new MimeBodyPart();
            if (emailNotificationDetails.isHtml()) {
                bodyPart.setContent((Object)emailNotificationDetails.getEmailBody(), "text/html; charset=utf-8");
            } else {
                bodyPart.setContent((Object)emailNotificationDetails.getEmailBody(), "text/plain; charset=utf-8");
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)bodyPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    protected Address[] toArray(List<String> emailAddresses) {
        if (emailAddresses == null) {
            return null;
        }
        emailAddresses = this.expandTokenisedAddresses(emailAddresses);
        int index = 0;
        Address[] addresses = new Address[emailAddresses.size()];
        for (String emailAddress : emailAddresses) {
            try {
                addresses[index++] = new InternetAddress(emailAddress);
            }
            catch (AddressException e) {
                logger.warn("Invalid email address", (Throwable)e);
            }
        }
        return addresses;
    }

    protected List<String> expandTokenisedAddresses(List<String> addresses) {
        ArrayList<String> reviewedAddresses = new ArrayList<String>();
        for (String address : addresses) {
            String[] splitAddresses;
            for (String splitAddress : splitAddresses = address.split(EMAIL_ADDRESS_SPLIT_REGEXP)) {
                if (splitAddress.length() <= 0) continue;
                reviewedAddresses.add(splitAddress);
            }
        }
        return reviewedAddresses;
    }

    public EmailNotifierConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EmailNotifierConfiguration configuration) {
        this.configuration = configuration;
        Properties mailProperties = new Properties();
        mailProperties.put("mail.debug", (Object)configuration.isMailDebug());
        if (configuration.getMailFrom() != null) {
            mailProperties.put("mail.from", configuration.getMailFrom());
        }
        mailProperties.put("mail.mime.access.strict", (Object)configuration.getMailMimeAddressStrict());
        if (configuration.getMailHost() != null) {
            mailProperties.put("mail.host", configuration.getMailHost());
        }
        if (configuration.getMailStoreProtocol() != null) {
            mailProperties.put("mail.store.protocol", configuration.getMailStoreProtocol());
        }
        if (configuration.getMailTransportProtocol() != null) {
            mailProperties.put("mail.transport.protocol", configuration.getMailTransportProtocol());
        }
        if (configuration.getMailUser() != null) {
            mailProperties.put("mail.user", configuration.getMailUser());
        }
        if (configuration.getMailSmtpClass() != null) {
            mailProperties.put("mail.smtp.class", configuration.getMailSmtpClass());
        }
        if (configuration.getMailSmtpHost() != null) {
            mailProperties.put("mail.smtp.host", configuration.getMailSmtpHost());
        }
        if (configuration.getMailSmtpPort() > 0) {
            mailProperties.put("mail.smtp.port", (Object)configuration.getMailSmtpPort());
        }
        if (configuration.getMailSmtpUser() != null) {
            mailProperties.put("mail.smtp.user", configuration.getMailSmtpUser());
        }
        if (configuration.getMailPopClass() != null) {
            mailProperties.put("mail.pop.class", configuration.getMailPopClass());
        }
        if (configuration.getMailPopHost() != null) {
            mailProperties.put("mail.pop.host", configuration.getMailPopHost());
        }
        if (configuration.getMailPopPort() > 0) {
            mailProperties.put("mail.pop.port", (Object)configuration.getMailPopPort());
        }
        if (configuration.getMailPopUser() != null) {
            mailProperties.put("mail.pop.user", configuration.getMailPopUser());
        }
        mailProperties.putAll((Map<?, ?>)configuration.getExtendedMailSessionProperties());
        this.session = Session.getInstance((Properties)mailProperties);
    }
}

