/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.notification.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.job.orchestration.model.notification.GenericNotificationDetails;
import org.ikasan.job.orchestration.model.notification.MonitorType;
import org.ikasan.notification.factory.NotificationThreadFactory;
import org.ikasan.notification.monitor.AbstractMonitorBase;
import org.ikasan.spec.scheduled.core.listener.SchedulerJobInstanceStateChangeEventListener;
import org.ikasan.spec.scheduled.event.model.SchedulerJobInstanceStateChangeEvent;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.notification.model.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateChangeMonitorImpl
extends AbstractMonitorBase<GenericNotificationDetails>
implements Monitor<GenericNotificationDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(StateChangeMonitorImpl.class);
    private final Map<String, Future<?>> mapOfRunningJobs = new HashMap();
    private Map<String, ExecutorService> mapOfRunningExecutors = new HashMap<String, ExecutorService>();
    private final boolean notificationEnabled;

    public StateChangeMonitorImpl(ExecutorService executorService, boolean notificationEnabled) {
        super(executorService);
        LOG.info("StateChangeMonitorImpl is being created!");
        this.notificationEnabled = notificationEnabled;
    }

    public void register(ContextInstance contextInstance) {
        if (this.notificationEnabled) {
            ContextMachine contextMachine = ContextMachineCache.instance().getByContextInstanceId(contextInstance.getId());
            ExecutorService executorService = Executors.newSingleThreadExecutor(new NotificationThreadFactory("StateChangeNotification"));
            Future<?> notificationScheduler = executorService.submit(new ErrorNotificationsRunner(contextMachine));
            this.mapOfRunningJobs.put(contextInstance.getId(), notificationScheduler);
            this.mapOfRunningExecutors.put(contextInstance.getId(), executorService);
            LOG.info("StateChangeMonitor has started monitoring for context {}, instance {}", (Object)contextInstance.getName(), (Object)contextInstance.getId());
            LOG.info(this.mapOfRunningJobs.size() + " number of Contexts are being monitored now!");
        } else {
            LOG.info("Notifications are not enabled!");
        }
    }

    public void unregister(ContextInstance contextInstance) {
        if (this.notificationEnabled) {
            if (this.mapOfRunningJobs.containsKey(contextInstance.getId())) {
                this.mapOfRunningJobs.get(contextInstance.getId()).cancel(true);
                LOG.info("Context {}, Context Instance Id {} notification has been unregistered", (Object)contextInstance.getName(), (Object)contextInstance.getId());
                this.mapOfRunningJobs.remove(contextInstance.getId());
            }
            if (this.mapOfRunningExecutors.containsKey(contextInstance.getId())) {
                super.shutdownExecutor(this.mapOfRunningExecutors.get(contextInstance.getId()));
                LOG.debug("Context {}, Context Instance Id {} notification executor has been unregistered", (Object)contextInstance.getName(), (Object)contextInstance.getId());
                this.mapOfRunningExecutors.remove(contextInstance.getId());
            }
            LOG.info("After unregistering Context {}, InstanceId {} - number of Contexts are being monitored now is {}", new Object[]{contextInstance.getName(), contextInstance.getId(), this.mapOfRunningJobs.size()});
        } else {
            LOG.info("Notifications are not enabled!");
        }
    }

    @Override
    public void invoke(GenericNotificationDetails status) {
        super.invoke(status);
    }

    protected class ErrorNotificationsRunner
    implements Runnable,
    SchedulerJobInstanceStateChangeEventListener {
        private final ContextMachine contextMachine;

        public ErrorNotificationsRunner(ContextMachine contextMachine) {
            this.contextMachine = contextMachine;
        }

        @Override
        public void run() {
            try {
                this.contextMachine.addSchedulerJobStateChangeEventListener((SchedulerJobInstanceStateChangeEventListener)this);
                LOG.info("ErrorNotificationsRunner is running for Context {} and InstanceId {}", (Object)this.contextMachine.getContext().getName(), (Object)this.contextMachine.getContext().getId());
                while (true) {
                    TimeUnit.SECONDS.sleep(3L);
                }
            }
            catch (Exception e) {
                LOG.info("ErrorNotificationsRunner has been Interrupted by an exception, most likely Context Instance has been removed. Context {}, InstanceId: {} - Exception {}", new Object[]{this.contextMachine.getContext().getName(), this.contextMachine.getContext().getId(), e.getMessage() + " - " + e});
                return;
            }
        }

        public void onSchedulerJobInstanceStateChangeEvent(SchedulerJobInstanceStateChangeEvent event) {
            if (event.getNewStatus().name().equalsIgnoreCase(InstanceStatus.ERROR.name())) {
                GenericNotificationDetails genericNotificationDetails = new GenericNotificationDetails(event.getSchedulerJobInstance().getAgentName(), event.getContextInstance().getName(), event.getSchedulerJobInstance().getChildContextName(), event.getSchedulerJobInstance().getJobName(), event.getSchedulerJobInstance().getContextInstanceId(), MonitorType.ERROR, event.getNewStatus());
                genericNotificationDetails.setFiredTime(event.getSchedulerJobInstance().getScheduledProcessEvent().getFireTime());
                genericNotificationDetails.setCompletedTime(event.getSchedulerJobInstance().getScheduledProcessEvent().getCompletionTime());
                StateChangeMonitorImpl.this.invoke(genericNotificationDetails);
            } else if (!event.getPreviousStatus().name().equalsIgnoreCase(InstanceStatus.RUNNING.name()) && event.getNewStatus().name().equalsIgnoreCase(InstanceStatus.RUNNING.name())) {
                GenericNotificationDetails genericNotificationDetails = new GenericNotificationDetails(event.getSchedulerJobInstance().getAgentName(), event.getContextInstance().getName(), event.getSchedulerJobInstance().getChildContextName(), event.getSchedulerJobInstance().getJobName(), event.getSchedulerJobInstance().getContextInstanceId(), MonitorType.START, event.getNewStatus());
                genericNotificationDetails.setFiredTime(event.getSchedulerJobInstance().getScheduledProcessEvent().getFireTime());
                StateChangeMonitorImpl.this.invoke(genericNotificationDetails);
            } else if (event.getNewStatus().name().equalsIgnoreCase(InstanceStatus.COMPLETE.name())) {
                GenericNotificationDetails genericNotificationDetails = new GenericNotificationDetails(event.getSchedulerJobInstance().getAgentName(), event.getContextInstance().getName(), event.getSchedulerJobInstance().getChildContextName(), event.getSchedulerJobInstance().getJobName(), event.getSchedulerJobInstance().getContextInstanceId(), MonitorType.COMPLETE, event.getNewStatus());
                genericNotificationDetails.setFiredTime(event.getSchedulerJobInstance().getScheduledProcessEvent().getFireTime());
                genericNotificationDetails.setCompletedTime(event.getSchedulerJobInstance().getScheduledProcessEvent().getCompletionTime());
                StateChangeMonitorImpl.this.invoke(genericNotificationDetails);
            }
        }
    }
}

