/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.notification.monitor;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.ikasan.job.orchestration.model.notification.GenericNotificationDetails;
import org.ikasan.job.orchestration.model.notification.MonitorType;
import org.ikasan.notification.factory.NotificationThreadFactory;
import org.ikasan.notification.monitor.AbstractMonitorBase;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.FileEventDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstanceRecord;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstanceService;
import org.ikasan.spec.scheduled.notification.model.Monitor;
import org.ikasan.spec.search.SearchResults;
import org.joda.time.DateTime;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueFileMonitorImpl
extends AbstractMonitorBase<GenericNotificationDetails>
implements Monitor<GenericNotificationDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(OverdueFileMonitorImpl.class);
    private SchedulerJobInstanceService schedulerJobInstanceService;
    private Map<String, ScheduledFuture<?>> mapOfRunningJobs = new HashMap();
    private Map<String, ScheduledExecutorService> mapOfRunningExecutors = new HashMap<String, ScheduledExecutorService>();
    private Integer fileArrivalToleranceInMinutes;
    private boolean notificationEnabled;
    private int notificationPollingInterval;

    public OverdueFileMonitorImpl(Integer fileArrivalToleranceInMinutes, ExecutorService executorService, SchedulerJobInstanceService schedulerJobInstanceService, boolean notificationEnabled, int notificationPollingInterval) {
        super(executorService);
        LOG.info("OverdueFileMonitorImpl is being created!");
        this.fileArrivalToleranceInMinutes = fileArrivalToleranceInMinutes;
        this.schedulerJobInstanceService = schedulerJobInstanceService;
        this.notificationEnabled = notificationEnabled;
        this.notificationPollingInterval = notificationPollingInterval;
    }

    @Override
    public void invoke(GenericNotificationDetails status) {
        super.invoke(status);
    }

    public void register(ContextInstance contextInstance) {
        if (this.notificationEnabled) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new NotificationThreadFactory("OverdueNotification"));
            ScheduledFuture<?> notificationScheduler = executorService.scheduleAtFixedRate(new OverdueFileNotificationsRunner(contextInstance), 1L, this.notificationPollingInterval, TimeUnit.MINUTES);
            this.mapOfRunningJobs.put(contextInstance.getId(), notificationScheduler);
            this.mapOfRunningExecutors.put(contextInstance.getId(), executorService);
            LOG.info("OverdueFileMonitor has started monitoring for context {}, instance {}", (Object)contextInstance.getName(), (Object)contextInstance.getId());
            LOG.info(this.mapOfRunningJobs.size() + " number of Contexts are being monitored now!");
        } else {
            LOG.info("Notifications are not enabled!");
        }
    }

    public void unregister(ContextInstance contextInstance) {
        if (this.notificationEnabled) {
            if (this.mapOfRunningJobs.containsKey(contextInstance.getId())) {
                this.mapOfRunningJobs.get(contextInstance.getId()).cancel(true);
                LOG.info("Context {}, Context Instance Id {} notification has been unregistered", (Object)contextInstance.getName(), (Object)contextInstance.getId());
                this.mapOfRunningJobs.remove(contextInstance.getId());
            }
            if (this.mapOfRunningExecutors.containsKey(contextInstance.getId())) {
                super.shutdownExecutor(this.mapOfRunningExecutors.get(contextInstance.getId()));
                LOG.debug("Context {}, Context Instance Id {} notification executor has been unregistered", (Object)contextInstance.getName(), (Object)contextInstance.getId());
                this.mapOfRunningExecutors.remove(contextInstance.getId());
            }
            LOG.info("After unregistering Context {}, InstanceId {} - number of Contexts are being monitored now is {}", new Object[]{contextInstance.getName(), contextInstance.getId(), this.mapOfRunningExecutors.size()});
        } else {
            LOG.info("Notifications are not enabled!");
        }
    }

    private boolean isJobOverdued(Date startTime, Long fireTime, String cronExpression) throws ParseException {
        CronTriggerImpl ct = new CronTriggerImpl("foo", "goo", cronExpression);
        ct.setStartTime(startTime);
        List fireTimes = TriggerUtils.computeFireTimes((OperableTrigger)ct, null, (int)1);
        Date firstFireTime = (Date)fireTimes.iterator().next();
        Date firstFireTimeWithTolerance = DateUtils.addMinutes((Date)firstFireTime, (int)this.fileArrivalToleranceInMinutes);
        LOG.debug("Start Time = {}, FireTime = {}, cronExpression = {}, firstFireTime = {}, firstFireTimeWithTolerance = {}, Return is = {}", new Object[]{startTime, new DateTime((Object)fireTime).toDate(), cronExpression, firstFireTime, firstFireTimeWithTolerance, firstFireTimeWithTolerance.before(new DateTime((Object)fireTime).toDate())});
        return firstFireTimeWithTolerance.before(new DateTime((Object)fireTime).toDate());
    }

    protected class OverdueFileNotificationsRunner
    implements Runnable {
        private ContextInstance contextInstance;

        public OverdueFileNotificationsRunner(ContextInstance contextInstance) {
            this.contextInstance = contextInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.COMPLETE.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.ENDED.toString())) {
                    OverdueFileMonitorImpl.this.unregister(this.contextInstance);
                    LOG.info("Context:" + this.contextInstance.getName() + ", InstanceId: " + this.contextInstance.getId() + " is " + this.contextInstance.getStatus().toString() + ", stopping the OverdueFileNotificationsRunner");
                    return;
                }
                if (this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.RUNNING.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.ERROR.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.WAITING.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.RELEASED.toString())) {
                    DateTime dateTime = new DateTime().withMillis(this.contextInstance.getCreatedDateTime());
                    SearchResults searchResults = OverdueFileMonitorImpl.this.schedulerJobInstanceService.getSchedulerJobInstancesByContextInstanceId(this.contextInstance.getId(), -1, -1, null, null);
                    int count = 0;
                    for (SchedulerJobInstanceRecord schedulerJobInstanceRecord : searchResults.getResultList()) {
                        FileEventDrivenJobInstance fileEventDrivenJobInstance;
                        SchedulerJobInstance schedulerJobInstance = schedulerJobInstanceRecord.getSchedulerJobInstance();
                        if (!schedulerJobInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.RUNNING.toString()) && !schedulerJobInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.WAITING.toString()) && !schedulerJobInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.COMPLETE.toString()) || !(schedulerJobInstance instanceof FileEventDrivenJobInstance) || StringUtils.isBlank((CharSequence)(fileEventDrivenJobInstance = (FileEventDrivenJobInstance)schedulerJobInstance).getSlaCronExpression())) continue;
                        long fireTime = new DateTime().toDate().getTime();
                        if (fileEventDrivenJobInstance.getScheduledProcessEvent() != null && fileEventDrivenJobInstance.getScheduledProcessEvent().getFireTime() > 0L) {
                            fireTime = fileEventDrivenJobInstance.getScheduledProcessEvent().getFireTime();
                        }
                        if (!OverdueFileMonitorImpl.this.isJobOverdued(dateTime.toDate(), fireTime, fileEventDrivenJobInstance.getSlaCronExpression())) continue;
                        GenericNotificationDetails genericNotificationDetails = new GenericNotificationDetails(fileEventDrivenJobInstance.getAgentName(), this.contextInstance.getName(), (String)fileEventDrivenJobInstance.getChildContextNames().get(0), fileEventDrivenJobInstance.getJobName(), this.contextInstance.getId(), MonitorType.OVERDUE, InstanceStatus.ERROR);
                        StringBuilder fileNames = new StringBuilder();
                        fileEventDrivenJobInstance.getFilenames().forEach(s -> fileNames.append((String)s).append(System.lineSeparator()));
                        genericNotificationDetails.setFileName(fileNames.toString());
                        genericNotificationDetails.setFilePath(fileEventDrivenJobInstance.getFilePath());
                        OverdueFileMonitorImpl.this.invoke(genericNotificationDetails);
                        ++count;
                    }
                    LOG.debug("OVERDUE HAS CREATED {} EVENTS for the context {} !", (Object)count, (Object)this.contextInstance.getName());
                }
            }
            catch (Exception e) {
                LOG.info("OverdueFileMonitorImpl has been Interrupted by an exception, most likely Context Instance has been removed. Context {}, InstanceId: {} - Exception {}", new Object[]{this.contextInstance.getName(), this.contextInstance.getId(), e.getMessage() + " - " + e});
            }
        }
    }
}

