/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.notification.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.ikasan.job.orchestration.model.notification.GenericNotificationDetails;
import org.ikasan.job.orchestration.model.notification.MonitorType;
import org.ikasan.notification.factory.NotificationThreadFactory;
import org.ikasan.notification.monitor.AbstractMonitorBase;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.InternalEventDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstanceRecord;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstanceService;
import org.ikasan.spec.scheduled.job.model.InternalEventDrivenJobRecord;
import org.ikasan.spec.scheduled.job.service.InternalEventDrivenJobService;
import org.ikasan.spec.scheduled.notification.model.Monitor;
import org.ikasan.spec.search.SearchResults;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunningTimesMonitorImpl
extends AbstractMonitorBase<GenericNotificationDetails>
implements Monitor<GenericNotificationDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(JobRunningTimesMonitorImpl.class);
    private SchedulerJobInstanceService schedulerJobInstanceService;
    private InternalEventDrivenJobService internalEventDrivenJobService;
    private boolean notificationEnabled;
    private int notificationPollingInterval;
    private Map<String, ScheduledFuture<?>> mapOfRunningJobs = new HashMap();
    private Map<String, ScheduledExecutorService> mapOfRunningExecutors = new HashMap<String, ScheduledExecutorService>();

    public JobRunningTimesMonitorImpl(ExecutorService executorService, SchedulerJobInstanceService schedulerJobInstanceService, InternalEventDrivenJobService internalEventDrivenJobService, boolean notificationEnabled, int notificationPollingInterval) {
        super(executorService);
        LOG.info("JobRunningTimesMonitorImpl is being created!");
        this.schedulerJobInstanceService = schedulerJobInstanceService;
        this.internalEventDrivenJobService = internalEventDrivenJobService;
        this.notificationEnabled = notificationEnabled;
        this.notificationPollingInterval = notificationPollingInterval;
    }

    @Override
    public void invoke(GenericNotificationDetails status) {
        super.invoke(status);
    }

    public void register(ContextInstance contextInstance) {
        if (this.notificationEnabled) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new NotificationThreadFactory("JobRunningNotification"));
            ScheduledFuture<?> notificationScheduler = executorService.scheduleAtFixedRate(new JobRunningTimesNotificationsRunner(contextInstance), 1L, this.notificationPollingInterval, TimeUnit.MINUTES);
            this.mapOfRunningJobs.put(contextInstance.getId(), notificationScheduler);
            this.mapOfRunningExecutors.put(contextInstance.getId(), executorService);
            LOG.info("JobRunningTimesMonitor has started monitoring for context {}, instance {}", (Object)contextInstance.getName(), (Object)contextInstance.getId());
            LOG.info(this.mapOfRunningJobs.size() + " number of Contexts are being monitored now!");
        } else {
            LOG.info("Notifications are not enabled!");
        }
    }

    public void unregister(ContextInstance contextInstance) {
        if (this.notificationEnabled) {
            if (this.mapOfRunningJobs.containsKey(contextInstance.getId())) {
                this.mapOfRunningJobs.get(contextInstance.getId()).cancel(true);
                LOG.info("Context {}, Context Instance Id {} notification has been unregistered", (Object)contextInstance.getName(), (Object)contextInstance.getId());
                this.mapOfRunningJobs.remove(contextInstance.getId());
            }
            if (this.mapOfRunningExecutors.containsKey(contextInstance.getId())) {
                super.shutdownExecutor(this.mapOfRunningExecutors.get(contextInstance.getId()));
                LOG.debug("Context {}, Context Instance Id {} notification executor has been unregistered", (Object)contextInstance.getName(), (Object)contextInstance.getId());
                this.mapOfRunningExecutors.remove(contextInstance.getId());
            }
            LOG.info("After unregistering Context {}, InstanceId {} - number of Contexts are being monitored now is {}", new Object[]{contextInstance.getName(), contextInstance.getId(), this.mapOfRunningJobs.size()});
        } else {
            LOG.info("Notifications are not enabled!");
        }
    }

    protected class JobRunningTimesNotificationsRunner
    implements Runnable {
        private ContextInstance contextInstance;

        public JobRunningTimesNotificationsRunner(ContextInstance contextInstance) {
            this.contextInstance = contextInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.COMPLETE.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.ENDED.toString())) {
                    JobRunningTimesMonitorImpl.this.unregister(this.contextInstance);
                    LOG.info("Context:" + this.contextInstance.getName() + ", InstanceId: " + this.contextInstance.getId() + " is " + this.contextInstance.getStatus().toString() + ", stopping the JobRunningTimesNotificationsRunner");
                    return;
                }
                if (this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.RUNNING.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.ERROR.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.WAITING.toString()) || this.contextInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.RELEASED.toString())) {
                    SearchResults searchResults = JobRunningTimesMonitorImpl.this.schedulerJobInstanceService.getSchedulerJobInstancesByContextInstanceId(this.contextInstance.getId(), -1, -1, null, null);
                    SearchResults jobDetailsResults = JobRunningTimesMonitorImpl.this.internalEventDrivenJobService.findByContext(this.contextInstance.getName(), -1, -1);
                    Map<String, InternalEventDrivenJobRecord> jobMap = this.createJobMap((SearchResults<InternalEventDrivenJobRecord>)jobDetailsResults);
                    long currentTime = System.currentTimeMillis();
                    for (SchedulerJobInstanceRecord schedulerJobInstanceRecord : searchResults.getResultList()) {
                        InternalEventDrivenJobInstance internalEventDrivenJobInstance;
                        SchedulerJobInstance schedulerJobInstance = schedulerJobInstanceRecord.getSchedulerJobInstance();
                        if (!(schedulerJobInstance instanceof InternalEventDrivenJobInstance) || !(internalEventDrivenJobInstance = (InternalEventDrivenJobInstance)schedulerJobInstance).getStatus().toString().equalsIgnoreCase(InstanceStatus.RUNNING.toString()) && !internalEventDrivenJobInstance.getStatus().toString().equalsIgnoreCase(InstanceStatus.COMPLETE.toString())) continue;
                        InternalEventDrivenJobRecord internalEventDrivenJobRecord = jobMap.get(internalEventDrivenJobInstance.getJobName());
                        long completionTime = internalEventDrivenJobInstance.getScheduledProcessEvent().getCompletionTime();
                        long fireTime = internalEventDrivenJobInstance.getScheduledProcessEvent().getFireTime();
                        long processTime = completionTime != 0L ? completionTime - fireTime : currentTime - fireTime;
                        double processedTimeInMinutes = (double)processTime / 1000.0 / 60.0;
                        LOG.debug("MIN = {}, MAX = {} AND PROCESSED MINS = {} - {} FIRED {} CURRENT {} COMPLETED {} ", new Object[]{internalEventDrivenJobRecord.getInternalEventDrivenJob().getMinExecutionTime(), internalEventDrivenJobRecord.getInternalEventDrivenJob().getMaxExecutionTime(), processedTimeInMinutes, processTime, new DateTime().withMillis(fireTime), new DateTime().withMillis(currentTime), new DateTime().withMillis(completionTime)});
                        if (internalEventDrivenJobRecord.getInternalEventDrivenJob().getMinExecutionTime() == -1L || internalEventDrivenJobRecord.getInternalEventDrivenJob().getMaxExecutionTime() == -1L || !(processedTimeInMinutes < (double)internalEventDrivenJobRecord.getInternalEventDrivenJob().getMinExecutionTime()) && !(processedTimeInMinutes > (double)internalEventDrivenJobRecord.getInternalEventDrivenJob().getMaxExecutionTime())) continue;
                        GenericNotificationDetails genericNotificationDetails = new GenericNotificationDetails(internalEventDrivenJobInstance.getAgentName(), this.contextInstance.getName(), (String)internalEventDrivenJobInstance.getChildContextNames().get(0), internalEventDrivenJobInstance.getJobName(), this.contextInstance.getId(), MonitorType.RUNNING_TIME, internalEventDrivenJobInstance.getStatus());
                        genericNotificationDetails.setMessage("Job has been running for over " + TimeUnit.MINUTES.convert(processTime, TimeUnit.MILLISECONDS) + " minutes. " + System.lineSeparator() + "Job is configured to alert when running time is less than " + internalEventDrivenJobRecord.getInternalEventDrivenJob().getMinExecutionTime() + "minutes, and max running time " + internalEventDrivenJobRecord.getInternalEventDrivenJob().getMaxExecutionTime());
                        JobRunningTimesMonitorImpl.this.invoke(genericNotificationDetails);
                    }
                }
            }
            catch (Exception e) {
                LOG.info("JobRunningTimesMonitorImpl has been Interrupted by an exception, most likely Context Instance has been removed. Context {}, InstanceId: {} - Exception {}", new Object[]{this.contextInstance.getName(), this.contextInstance.getId(), e.getMessage() + " - " + e});
            }
        }

        private Map<String, InternalEventDrivenJobRecord> createJobMap(SearchResults<InternalEventDrivenJobRecord> jobDetailsResults) {
            HashMap<String, InternalEventDrivenJobRecord> resultMap = new HashMap<String, InternalEventDrivenJobRecord>();
            for (InternalEventDrivenJobRecord jobRecord : jobDetailsResults.getResultList()) {
                resultMap.put(jobRecord.getJobName(), jobRecord);
            }
            return resultMap;
        }
    }
}

