/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.notification.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.ikasan.spec.scheduled.notification.model.Monitor;
import org.ikasan.spec.scheduled.notification.model.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonitorBase<T>
implements Monitor<T> {
    private static Logger logger = LoggerFactory.getLogger(AbstractMonitorBase.class);
    protected final ExecutorService executorService;
    protected List<Notifier> notifiers = new ArrayList<Notifier>();

    public AbstractMonitorBase(ExecutorService executorService) {
        this.executorService = executorService;
        if (executorService == null) {
            throw new IllegalArgumentException("executorService cannot be 'null'");
        }
    }

    public void invoke(T notification) {
        if (this.notifiers == null || this.notifiers.size() == 0) {
            logger.info("Monitor has no registered notifiers");
            return;
        }
        if (this.executorService == null || this.executorService.isShutdown()) {
            logger.warn("Cannot invoke Monitor after destroy has been called - executorService is null or shutdown");
            return;
        }
        for (Notifier notifier : this.notifiers) {
            this.executorService.execute(() -> {
                try {
                    notifier.invoke(notification);
                }
                catch (RuntimeException e) {
                    logger.warn("Failed to invoke notifier[" + notifier.getClass().getName() + "]", (Throwable)e);
                    e.printStackTrace();
                }
            });
        }
    }

    public void destroy() {
        if (this.executorService != null) {
            logger.info("Monitor shutting down executorService");
            this.executorService.shutdownNow();
        }
    }

    public void setNotifiers(List<Notifier> notifiers) {
        this.notifiers = notifiers;
    }

    public List<Notifier> getNotifiers() {
        return this.notifiers;
    }

    public void addNotifier(Notifier notifier) {
        this.getNotifiers().add(notifier);
    }

    protected void shutdownExecutor(ExecutorService executor) {
        executor.shutdownNow();
        try {
            if (!executor.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

