/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ikasan.job.orchestration.model.context.ContextBundleImpl;
import org.ikasan.job.orchestration.service.ContextService;
import org.ikasan.spec.scheduled.context.model.ContextBundle;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.job.model.SchedulerJob;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationContext;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationDetails;
import org.ikasan.spec.scheduled.profile.model.ContextProfileRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextImportZipUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ContextImportZipUtils.class);

    public static ContextBundle extractZipFile(InputStream inputStream) {
        ArrayList<SchedulerJob> contextJobs = new ArrayList<SchedulerJob>();
        ArrayList<ContextProfileRecord> contextProfileRecords = new ArrayList<ContextProfileRecord>();
        ArrayList<EmailNotificationDetails> emailNotificationDetails = new ArrayList<EmailNotificationDetails>();
        AtomicReference emailNotificationContexts = new AtomicReference();
        AtomicReference contextTemplate = new AtomicReference();
        try {
            ContextService contextService = new ContextService();
            AtomicReference parentDirectory = new AtomicReference();
            ContextImportZipUtils.readZipInputStream(inputStream, (entry, outputStream) -> {
                if (parentDirectory.get() == null) {
                    parentDirectory.set(entry.getName());
                }
                String contextDirectory = parentDirectory + "context/";
                String fileJobsDirectory = parentDirectory + "jobs/file/";
                String internalJobsDirectory = parentDirectory + "jobs/internal/";
                String quartzJobsDirectory = parentDirectory + "jobs/quartz/";
                String globalJobsDirectory = parentDirectory + "jobs/global/";
                String contextProfileDirectory = parentDirectory + "profiles/";
                String emailNotificationDirectory = parentDirectory + "notification/";
                String emailNotificationDetailDirectory = parentDirectory + "notification_details/";
                if (!entry.isDirectory() && entry.getName().startsWith(contextDirectory) && entry.getName().endsWith(".json")) {
                    contextTemplate.set((ContextTemplate)ContextImportZipUtils.getContextArtifact("contextTemplate", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(fileJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("file", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(internalJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("internal", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(quartzJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("quartz", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(globalJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("global", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(contextProfileDirectory) && entry.getName().endsWith(".json")) {
                    contextProfileRecords.add((ContextProfileRecord)ContextImportZipUtils.getContextArtifact("profiles", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(emailNotificationDirectory) && entry.getName().endsWith(".json")) {
                    emailNotificationContexts.set((EmailNotificationContext)ContextImportZipUtils.getContextArtifact("notification", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(emailNotificationDetailDirectory) && entry.getName().endsWith(".json")) {
                    emailNotificationDetails.add((EmailNotificationDetails)ContextImportZipUtils.getContextArtifact("notification_details", outputStream.toString(), contextService));
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Could not read zip file, Error: " + e.getMessage());
            throw new RuntimeException(e);
        }
        return new ContextBundleImpl((ContextTemplate)contextTemplate.get(), contextJobs, contextProfileRecords, emailNotificationDetails, (EmailNotificationContext)emailNotificationContexts.get());
    }

    private static void readZipInputStream(InputStream inputStream, BiConsumer<ZipEntry, ByteArrayOutputStream> biConsumer) {
        try {
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(inputStream);
            while ((entry = zipInput.getNextEntry()) != null) {
                int length;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = zipInput.read(buffer)) != -1) {
                    outStream.write(buffer, 0, length);
                }
                biConsumer.accept(entry, outStream);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not read zip input stream, Error: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static Object getContextArtifact(String type, String json, ContextService service) {
        try {
            switch (type) {
                case "contextTemplate": {
                    return service.getContextTemplate(json);
                }
                case "file": {
                    return service.getFileEventDrivenJob(json);
                }
                case "internal": {
                    return service.getInternalEventDrivenJob(json);
                }
                case "quartz": {
                    return service.getQuartzScheduleDrivenJob(json);
                }
                case "global": {
                    return service.getGlobalEventJob(json);
                }
                case "profiles": {
                    return service.getContextProfileRecord(json);
                }
                case "notification": {
                    return service.getEmailNotificationContext(json);
                }
                case "notification_details": {
                    return service.getEmailNotificationDetails(json);
                }
            }
            throw new RuntimeException("Unknown job type: " + type);
        }
        catch (JsonProcessingException e) {
            LOG.warn(String.format("Could not read json for job type %s, Error: %s", type, e.getMessage()));
            throw new RuntimeException(e);
        }
    }
}

