/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.model.instance;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ikasan.job.orchestration.model.context.ContextImpl;
import org.ikasan.job.orchestration.util.ObjectMapperFactory;
import org.ikasan.spec.scheduled.event.model.SchedulerJobInitiationEvent;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.JobLockInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.instance.model.StatefulEntity;

public class ContextInstanceImpl
extends ContextImpl<ContextInstance, ContextParameterInstance, SchedulerJobInstance, JobLockInstance>
implements StatefulEntity,
ContextInstance {
    private ObjectMapper objectMapper = ObjectMapperFactory.newInstance();
    private String id = UUID.randomUUID().toString();
    private long createdDateTime;
    private long updatedDateTime;
    private long startTime;
    private long projectedEndTime;
    private long endTime;
    private boolean isRunContextUntilManuallyEnded;
    private String timezone;
    private InstanceStatus status = InstanceStatus.WAITING;
    private Map<String, SchedulerJobInitiationEvent> heldJobs;

    public ContextInstanceImpl() {
        this.createdDateTime = System.currentTimeMillis();
        this.updatedDateTime = System.currentTimeMillis();
        this.heldJobs = new HashMap<String, SchedulerJobInitiationEvent>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(long createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public long getUpdatedDateTime() {
        return this.updatedDateTime;
    }

    public void setUpdatedDateTime(long updatedDateTime) {
        this.updatedDateTime = updatedDateTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getProjectedEndTime() {
        return this.projectedEndTime;
    }

    public void setProjectedEndTime(long projectedEndTime) {
        this.projectedEndTime = projectedEndTime;
    }

    public boolean isRunContextUntilManuallyEnded() {
        return this.isRunContextUntilManuallyEnded;
    }

    public void setRunContextUntilManuallyEnded(boolean runContextUntilManuallyEnded) {
        this.isRunContextUntilManuallyEnded = runContextUntilManuallyEnded;
    }

    @Override
    public String getTimezone() {
        return this.timezone;
    }

    @Override
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public InstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(InstanceStatus status) {
        if (status != null) {
            this.status = status;
        }
    }

    public Map<String, SchedulerJobInitiationEvent> getHeldJobs() {
        return this.heldJobs;
    }

    public void setHeldJobs(Map<String, SchedulerJobInitiationEvent> heldJobs) {
        this.heldJobs = heldJobs;
    }

    @Override
    public String toString() {
        try {
            return this.objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return String.format("Could not resolve context instance as string. Context Name[%s], Context Instance Id[%s]", this.name, this.id);
        }
    }
}

