/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.systemevent.service;

import java.util.Date;
import org.apache.log4j.Logger;
import org.ikasan.framework.management.search.PagedSearchResult;
import org.ikasan.framework.systemevent.dao.SystemEventDao;
import org.ikasan.framework.systemevent.model.SystemEvent;
import org.ikasan.framework.systemevent.service.SystemEventService;

public class SystemEventServiceImpl
implements SystemEventService {
    private Logger logger = Logger.getLogger(SystemEventServiceImpl.class);
    private SystemEventDao systemEventDao;
    private Long eventExpiryMinutes;

    public SystemEventServiceImpl(SystemEventDao systemEventDao, Long eventExpiryMinutes) {
        this.systemEventDao = systemEventDao;
        this.eventExpiryMinutes = eventExpiryMinutes;
    }

    @Override
    public void logSystemEvent(String subject, String action, String actor) {
        Date now = new Date();
        Date expiry = null;
        if (this.eventExpiryMinutes != null) {
            expiry = new Date(now.getTime() + 60000L * this.eventExpiryMinutes);
        }
        this.systemEventDao.save(new SystemEvent(subject, action, now, actor, expiry));
    }

    @Override
    public PagedSearchResult<SystemEvent> listSystemEvents(int pageNo, int pageSize, String orderBy, boolean orderAscending, String subject, String action, Date timestampFrom, Date timestampTo, String actor) {
        return this.systemEventDao.find(pageNo, pageSize, orderBy, orderAscending, subject, action, timestampFrom, timestampTo, actor);
    }

    @Override
    public void housekeep() {
        long before = System.currentTimeMillis();
        this.systemEventDao.deleteExpired();
        long after = System.currentTimeMillis();
        this.logger.info((Object)("housekeep completed in [" + (after - before) + "]ms"));
    }
}

