/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.security.model;

import java.util.HashSet;
import java.util.Set;
import org.ikasan.framework.security.model.Authority;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;

public class User
implements UserDetails {
    private static final long serialVersionUID = 8975017088981341914L;
    private Long id;
    private String username;
    private String password;
    private String email;
    private boolean enabled;
    private Set<Authority> grantedAuthorities = new HashSet<Authority>();

    public User(String username, String password, String email, boolean enabled) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.enabled = enabled;
    }

    private User() {
    }

    private Set<Authority> getGrantedAuthorities() {
        return this.grantedAuthorities;
    }

    public void setGrantedAuthorities(Set<Authority> grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.grantedAuthorities.toArray(new GrantedAuthority[0]);
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void grantAuthority(Authority authority) {
        if (this.grantedAuthorities.contains(authority)) {
            throw new IllegalArgumentException("Authority [" + authority + "] is already granted to user [" + this + "]");
        }
        this.grantedAuthorities.add(authority);
    }

    public void revokeAuthority(Authority authority) {
        if (!this.grantedAuthorities.contains(authority)) {
            throw new IllegalArgumentException("Authority [" + authority + "] has not been granted to user [" + this + "]");
        }
        this.grantedAuthorities.remove(authority);
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("User [");
        sb.append("username=");
        sb.append(this.username);
        sb.append(", ");
        sb.append("email=");
        sb.append(this.email);
        sb.append(", ");
        sb.append("enabled=");
        sb.append(this.enabled);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        return !(this.email == null ? other.email != null : !this.email.equals(other.email));
    }
}

