/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.plugins;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.ikasan.framework.plugins.invoker.PluginInvocationException;

public abstract class PojoWrapperPlugin {
    protected Object pojo;
    private String pojoMethodName;
    private static Logger logger = Logger.getLogger(PojoWrapperPlugin.class);

    public PojoWrapperPlugin(Object pojo, String pojoMethodName) {
        this.pojo = pojo;
        this.pojoMethodName = pojoMethodName;
    }

    protected void invoke(Object[] params, Class<?>[] paramTypes) throws PluginInvocationException {
        logger.info((Object)("about to call wrapped plugin [" + this.pojo + "] "));
        Class<?> clazz = this.pojo.getClass();
        try {
            Method method = clazz.getMethod(this.pojoMethodName, paramTypes);
            method.invoke(this.pojo, params);
        }
        catch (SecurityException e) {
            this.handleException(params, e);
        }
        catch (NoSuchMethodException e) {
            this.handleException(params, e);
        }
        catch (IllegalArgumentException e) {
            this.handleException(params, e);
        }
        catch (IllegalAccessException e) {
            this.handleException(params, e);
        }
        catch (InvocationTargetException e) {
            this.handleException(params, e);
        }
    }

    private void handleException(Object[] params, Exception e) throws PluginInvocationException {
        throw new PluginInvocationException("Exception invoking [" + this.pojoMethodName + "] on wrapped pojo [" + this.pojo + "] with arguments [" + this.formatParams(params) + "]", e);
    }

    private String formatParams(Object[] params) {
        StringBuffer sb = new StringBuffer("{");
        for (int i = 0; i < params.length; ++i) {
            Object object = params[i];
            sb.append(object);
            if (i >= params.length - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

