/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.payload.service;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.common.security.IkasanSecurityConf;
import org.ikasan.framework.messaging.jms.JndiDestinationFactory;
import org.ikasan.framework.payload.serialisation.JmsMessagePayloadSerialiser;
import org.ikasan.framework.payload.service.PayloadPublisher;

public class JMSPayloadPublisher
implements PayloadPublisher {
    private static Logger logger = Logger.getLogger(JMSPayloadPublisher.class);
    private Destination destination;
    private ConnectionFactory connectionFactory;
    private IkasanSecurityConf ikasanSecurityConf;
    private JmsMessagePayloadSerialiser<? extends Message> jmsMessagePayloadSerialiser;
    private JndiDestinationFactory jndiDestinationFactory;
    private Long timeToLive;
    private Integer priority;

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public JMSPayloadPublisher(Destination destination, ConnectionFactory connectionFactory, JmsMessagePayloadSerialiser<? extends Message> jmsMessagePayloadSerialiser, IkasanSecurityConf ikasanSecurityConf) {
        this.destination = destination;
        this.connectionFactory = connectionFactory;
        this.jmsMessagePayloadSerialiser = jmsMessagePayloadSerialiser;
        this.ikasanSecurityConf = ikasanSecurityConf;
    }

    public JMSPayloadPublisher(JndiDestinationFactory jndiDestinationFactory, ConnectionFactory connectionFactory, JmsMessagePayloadSerialiser<? extends Message> jmsMessagePayloadSerialiser, IkasanSecurityConf ikasanSecurityConf) {
        this.jndiDestinationFactory = jndiDestinationFactory;
        this.connectionFactory = connectionFactory;
        this.jmsMessagePayloadSerialiser = jmsMessagePayloadSerialiser;
        this.ikasanSecurityConf = ikasanSecurityConf;
    }

    @Override
    public void publish(Payload payload) throws ResourceException {
        Destination thisDestination;
        try {
            thisDestination = this.destination != null ? this.destination : this.jndiDestinationFactory.getDestination(true);
        }
        catch (NamingException e1) {
            throw new ResourceException("NamingException caught whilst attempting to find destination with jndiName[" + this.jndiDestinationFactory.getJndiName() + "], environment[" + this.jndiDestinationFactory.getEnvironment() + "]", (Throwable)e1);
        }
        Connection connection = null;
        try {
            connection = this.createConnection();
            Session session = connection.createSession(true, 1);
            Message message = this.jmsMessagePayloadSerialiser.toMessage(payload, session);
            MessageProducer messageProducer = session.createProducer(thisDestination);
            if (this.timeToLive != null) {
                messageProducer.setTimeToLive(this.timeToLive.longValue());
            }
            if (this.priority != null) {
                messageProducer.setPriority(this.priority.intValue());
            }
            messageProducer.send(message);
            logger.info((Object)("Successfully sent message to destination [" + this.destination + "]. " + payload.getId()));
        }
        catch (JMSException e) {
            throw new ResourceException("JMS Exception caught whilst publishing", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    throw new ResourceException("JMS Exception caught when closing connection", (Throwable)e);
                }
            }
        }
    }

    private Connection createConnection() throws JMSException {
        Connection connection = this.ikasanSecurityConf != null ? this.connectionFactory.createConnection(this.ikasanSecurityConf.getJMSUsername(), this.ikasanSecurityConf.getJMSPassword()) : this.connectionFactory.createConnection();
        return connection;
    }
}

