/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.payload.serialisation;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.ikasan.common.Payload;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.payload.serialisation.JmsMessagePayloadSerialiser;

public class TextMessagePayloadSerialiser
implements JmsMessagePayloadSerialiser<TextMessage> {
    private PayloadFactory payloadFactory;

    @Override
    public Class<? extends Message> getSupportedMessageType() {
        return TextMessage.class;
    }

    @Override
    public boolean supports(Class<? extends Message> messageClass) {
        return TextMessage.class.isAssignableFrom(messageClass);
    }

    @Override
    public TextMessage toMessage(Payload payload, Session session) throws JMSException {
        TextMessage textMessage = session.createTextMessage();
        textMessage.setText(new String(payload.getContent()));
        return textMessage;
    }

    @Override
    public Payload toPayload(TextMessage message) throws JMSException {
        return this.payloadFactory.newPayload(message.getJMSMessageID(), message.getText().getBytes());
    }

    public void setPayloadFactory(PayloadFactory payloadFactory) {
        this.payloadFactory = payloadFactory;
    }
}

