/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.module.service;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ikasan.framework.flow.initiator.dao.InitiatorStartupControlDao;
import org.ikasan.framework.initiator.Initiator;
import org.ikasan.framework.initiator.InitiatorStartupControl;
import org.ikasan.framework.module.Module;
import org.ikasan.framework.module.container.ModuleContainer;
import org.ikasan.framework.module.service.ModuleInitialisationService;
import org.ikasan.framework.security.model.Authority;
import org.ikasan.framework.security.service.UserService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ModuleInitialisationServiceImpl
implements ModuleInitialisationService,
ApplicationContextAware,
InitializingBean {
    private Logger logger = Logger.getLogger(ModuleInitialisationServiceImpl.class);
    private ModuleContainer moduleContainer;
    private InitiatorStartupControlDao initiatorStartupControlDao;
    private ApplicationContext platformContext;
    private UserService userService;

    public ModuleInitialisationServiceImpl(ModuleContainer moduleContainer, UserService userService, InitiatorStartupControlDao initiatorStartupControlDao) {
        this.moduleContainer = moduleContainer;
        this.userService = userService;
        this.initiatorStartupControlDao = initiatorStartupControlDao;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.platformContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        ClassPathXmlApplicationContext moduleLoadingContext = new ClassPathXmlApplicationContext("moduleLoading.xml");
        List moduleLoaderFiles = (List)moduleLoadingContext.getBean("moduleLoader-config-files");
        for (String moduleLoaderFile : moduleLoaderFiles) {
            this.loadModule(moduleLoaderFile);
        }
    }

    private void loadModule(String moduleLoaderFile) {
        this.logger.info((Object)("loading module from file[" + moduleLoaderFile + "]"));
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{moduleLoaderFile}, this.platformContext);
        Map moduleBeans = applicationContext.getBeansOfType(Module.class);
        for (Module module : moduleBeans.values()) {
            this.initialiseModuleSecurity(module);
            for (Initiator initiator : module.getInitiators()) {
                InitiatorStartupControl initiatorStartupControl = this.initiatorStartupControlDao.getInitiatorStartupControl(module.getName(), initiator.getName());
                if (!InitiatorStartupControl.StartupType.AUTOMATIC.equals((Object)initiatorStartupControl.getStartupType())) continue;
                initiator.start();
            }
            this.moduleContainer.add(module);
        }
    }

    private void initialiseModuleSecurity(Module module) {
        Authority moduleAdminAuthority;
        Authority moduleUserAuthority;
        List<Authority> existingAuthorities = this.userService.getAuthorities();
        if (!existingAuthorities.contains(moduleUserAuthority = new Authority("USER_" + module.getName(), "Allows user access to the " + module.getName() + " module. This is typically assigned to business users"))) {
            this.logger.info((Object)("module user authority does not exist for module [" + module.getName() + "], creating..."));
            this.userService.createAuthority(moduleUserAuthority);
        }
        if (!existingAuthorities.contains(moduleAdminAuthority = new Authority("ADMIN_" + module.getName(), "Allows administrator access to the " + module.getName() + " module. This is typically assigned to business administrators"))) {
            this.logger.info((Object)("module admin authority does not exist for module [" + module.getName() + "], creating..."));
            this.userService.createAuthority(moduleAdminAuthority);
        }
    }
}

