/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.module.loader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.framework.module.Module;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ModuleFactoryBean
implements FactoryBean,
ApplicationContextAware {
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private ApplicationContext parentContext;
    private Logger logger = Logger.getLogger(ModuleFactoryBean.class);
    private List<String> environmentalisationBeanDefinitionFileNameList;
    private List<String> moduleBeanDefinitionFileNameList;
    private File environmentalisationDirectory;
    private String moduleBeanName;
    private Module module;

    public ModuleFactoryBean(List<String> environmentalisationBeanDefinitionFileNameList, List<String> moduleBeanDefinitionFileNameList, File environmentalisationDirectory, String moduleBeanName) {
        this.environmentalisationBeanDefinitionFileNameList = environmentalisationBeanDefinitionFileNameList;
        this.moduleBeanDefinitionFileNameList = moduleBeanDefinitionFileNameList;
        this.environmentalisationDirectory = environmentalisationDirectory;
        this.moduleBeanName = moduleBeanName;
    }

    private void instantiateModule(List<String> environmentalisationBeanDefFileNameList, List<String> moduleBeanDefFileNameList, File environmentalisationDir, String beanName) {
        this.logger.info((Object)"instantiateModule called for moduleBeanName");
        if (!environmentalisationDir.exists()) {
            throw new RuntimeException("environmentalisation directory cannot be found [" + environmentalisationDir.getAbsolutePath() + "]");
        }
        FileSystemXmlApplicationContext moduleEnvironmentalisation = null;
        ArrayList<String> environmentalisationBeanDefinitionPathList = new ArrayList<String>();
        for (String relativePath : environmentalisationBeanDefFileNameList) {
            String cleanRelativePath = relativePath.trim();
            File environmentalisationBeanDefinitionFile = new File(environmentalisationDir, cleanRelativePath);
            if (!environmentalisationBeanDefinitionFile.exists()) {
                throw new RuntimeException("environmentalisation file cannot be found [" + environmentalisationBeanDefinitionFile.getAbsolutePath() + "]");
            }
            environmentalisationBeanDefinitionPathList.add(FILE_SEPARATOR + environmentalisationBeanDefinitionFile.getAbsolutePath());
        }
        String[] environmentalisationBeanDefinitionPath = new String[environmentalisationBeanDefinitionPathList.size()];
        environmentalisationBeanDefinitionPathList.toArray(environmentalisationBeanDefinitionPath);
        moduleEnvironmentalisation = new FileSystemXmlApplicationContext(environmentalisationBeanDefinitionPath, this.parentContext);
        ArrayList<String> moduleBeanDefinitionList = new ArrayList<String>();
        for (String moduleBeanDefinitionFileName : moduleBeanDefFileNameList) {
            moduleBeanDefinitionList.add(moduleBeanDefinitionFileName.trim());
        }
        String[] moduleBeanDefinitionPath = new String[moduleBeanDefinitionList.size()];
        moduleBeanDefinitionList.toArray(moduleBeanDefinitionPath);
        ClassPathXmlApplicationContext moduleBeanDefintion = new ClassPathXmlApplicationContext(moduleBeanDefinitionPath, (ApplicationContext)moduleEnvironmentalisation);
        this.module = (Module)moduleBeanDefintion.getBean(beanName);
    }

    public Object getObject() {
        if (this.module == null) {
            this.instantiateModule(this.environmentalisationBeanDefinitionFileNameList, this.moduleBeanDefinitionFileNameList, this.environmentalisationDirectory, this.moduleBeanName);
        }
        return this.module;
    }

    public Class getObjectType() {
        return Module.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }
}

