/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.messaging.jms;

import java.util.Hashtable;
import java.util.Map;
import javax.jms.Destination;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.ikasan.framework.messaging.jms.JndiDestinationFactory;

public class DefaultJndiDestinationFactory
implements JndiDestinationFactory {
    private static final Logger logger = Logger.getLogger(DefaultJndiDestinationFactory.class);
    private String jndiName;
    private Hashtable<String, String> environment;
    private Destination destination = null;

    public DefaultJndiDestinationFactory(String jndiName, Map<String, String> environment) {
        logger.info((Object)("constructor called with environment:" + environment));
        this.jndiName = jndiName;
        this.environment = new Hashtable<String, String>(environment);
    }

    public DefaultJndiDestinationFactory(String jndiName, Map<String, String> environment, boolean lookupOnCreation) {
        this(jndiName, environment);
        if (lookupOnCreation) {
            try {
                this.getDestination(false);
            }
            catch (NamingException namingException) {
                logger.warn((Object)("failed to find Destination on creation. " + namingException.getMessage()));
            }
        }
    }

    @Override
    public Destination getDestination(boolean allowCachedResult) throws NamingException {
        if (this.destination == null || !allowCachedResult) {
            InitialContext context = new InitialContext(this.environment);
            this.destination = (Destination)context.lookup(this.jndiName);
        }
        return this.destination;
    }

    @Override
    public Map<?, ?> getEnvironment() {
        return this.environment;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }
}

