/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.scheduled.quartz;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.event.service.EventProvider;
import org.ikasan.framework.exception.IkasanExceptionAction;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.AbstractInitiator;
import org.ikasan.framework.initiator.InitiatorOperationException;
import org.ikasan.framework.initiator.scheduled.quartz.QuartzDrivenInitiator;
import org.ikasan.framework.initiator.scheduled.quartz.QuartzStatefulJob;
import org.ikasan.framework.monitor.MonitorSubject;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class QuartzStatefulScheduledDrivenInitiator
extends AbstractInitiator
implements QuartzDrivenInitiator,
MonitorSubject {
    private static final String INITIATOR_JOB_NAME = "initiatorJob";
    public static final String QUARTZ_SCHEDULE_DRIVEN_INITIATOR_TYPE = "QuartzScheduleDrivenInitiator";
    public static final String REINVOKE_IMMEDIATELY_FLAG = "invokeAgainImmediately";
    private static Logger logger = Logger.getLogger(QuartzStatefulScheduledDrivenInitiator.class);
    private static final String RETRY_TRIGGER_NAME = "retry_trigger";
    protected EventProvider eventProvider = null;
    protected Scheduler scheduler;
    private List<Trigger> triggers;
    private JobDetail jobDetail;
    private IkasanExceptionHandler exceptionHandler;
    private boolean allowImmediateReinvocationOnEvent = false;

    public QuartzStatefulScheduledDrivenInitiator(String initiatorName, String moduleName, EventProvider eventProvider, Flow flow, IkasanExceptionHandler exceptionHandler) {
        super(moduleName, initiatorName, flow, exceptionHandler);
        this.eventProvider = eventProvider;
        this.exceptionHandler = exceptionHandler;
        this.notifyMonitorListeners();
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    protected void startRetryCycle(Integer maxAttempts, long delay) throws InitiatorOperationException {
        try {
            this.scheduler.pauseJob(INITIATOR_JOB_NAME, this.getJobGroup());
            Trigger recoveryTrigger = TriggerUtils.makeImmediateTrigger((String)RETRY_TRIGGER_NAME, (int)maxAttempts, (long)delay);
            recoveryTrigger.setGroup(this.getTriggerGroup());
            recoveryTrigger.setJobName(INITIATOR_JOB_NAME);
            recoveryTrigger.setJobGroup(this.getJobGroup());
            recoveryTrigger.setStartTime(new Date(System.currentTimeMillis() + delay));
            Date scheduled = this.scheduler.scheduleJob(recoveryTrigger);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Starting retry cycle on Initiator [" + this.getName() + "] at [" + scheduled + "]."));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added retry trigger [" + recoveryTrigger.getName() + "] group [" + recoveryTrigger.getGroup() + "]."));
                }
            }
        }
        catch (SchedulerException e) {
            throw new InitiatorOperationException("Failed to start retry cycle on Initiator [" + this.getName() + "] [" + "].", (Exception)((Object)e));
        }
    }

    private String getJobGroup() {
        return this.moduleName + "-" + this.name;
    }

    @Override
    protected void completeRetryCycle() throws InitiatorOperationException {
        try {
            this.cancelRetryTrigger();
            this.scheduler.resumeJob(INITIATOR_JOB_NAME, this.getJobGroup());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Successfully completed retry cycle on Initiator [" + this.getName() + "]."));
            }
        }
        catch (SchedulerException e) {
            throw new InitiatorOperationException("Failed Initiator [" + this.getName() + "] [" + "] on completeRetryCycle.", (Exception)((Object)e));
        }
    }

    @Override
    protected void cancelRetryCycle() throws InitiatorOperationException {
        this.cancelRetryTrigger();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Cancelled retry cycle on Initiator [" + this.getName() + "]."));
        }
    }

    private void cancelRetryTrigger() throws InitiatorOperationException {
        this.retryCount = 0;
        try {
            Trigger recoveryTrigger = this.getRecoveryTrigger();
            if (recoveryTrigger != null) {
                this.scheduler.unscheduleJob(recoveryTrigger.getName(), recoveryTrigger.getGroup());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Initiator [" + this.getName() + "] trigger [" + recoveryTrigger.getName() + "] group [" + recoveryTrigger.getGroup() + "] cancelled."));
                }
            }
        }
        catch (SchedulerException e) {
            throw new InitiatorOperationException("Failed to cancel retry trigger for Initiator [" + this.getName() + "] [" + "].", (Exception)((Object)e));
        }
    }

    private Trigger getRecoveryTrigger() {
        Trigger trigger = null;
        try {
            trigger = this.scheduler.getTrigger(RETRY_TRIGGER_NAME, this.getTriggerGroup());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return trigger;
    }

    @Override
    protected void stopInitiator() throws InitiatorOperationException {
        try {
            Trigger[] triggers;
            for (Trigger trigger : triggers = this.scheduler.getTriggersOfJob(INITIATOR_JOB_NAME, this.getJobGroup())) {
                this.scheduler.unscheduleJob(trigger.getName(), trigger.getGroup());
            }
            logger.info((Object)("Initiator [" + this.getName() + "] stopped."));
        }
        catch (SchedulerException e) {
            throw new InitiatorOperationException("Failed to stop Initiator [" + this.getName() + "] [" + "].", (Exception)((Object)e));
        }
    }

    @Override
    protected void startInitiator() throws InitiatorOperationException {
        try {
            this.jobDetail = new JobDetail(INITIATOR_JOB_NAME, this.getJobGroup(), QuartzStatefulJob.class);
            boolean firstTrigger = true;
            for (Trigger trigger : this.triggers) {
                trigger.setGroup(this.getTriggerGroup());
                if (firstTrigger) {
                    this.scheduler.scheduleJob(this.jobDetail, trigger);
                    firstTrigger = false;
                    continue;
                }
                trigger.setJobGroup(this.getJobGroup());
                trigger.setJobName(INITIATOR_JOB_NAME);
                this.scheduler.scheduleJob(trigger);
            }
            logger.info((Object)("Initiator [" + this.getName() + "] started."));
        }
        catch (SchedulerException e) {
            throw new InitiatorOperationException("Failed to start Initiator [" + this.getName() + "] [" + "].", (Exception)((Object)e));
        }
    }

    private String getTriggerGroup() {
        return this.moduleName + "-" + this.name;
    }

    @Override
    public String getType() {
        return QUARTZ_SCHEDULE_DRIVEN_INITIATOR_TYPE;
    }

    @Override
    public boolean isRecovering() {
        return this.getRecoveryTrigger() != null;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isRunning() {
        boolean running = false;
        try {
            boolean bl = running = !this.scheduler.isInStandbyMode() && !this.scheduler.isShutdown();
            if (running) {
                Trigger[] triggersOfJob = this.scheduler.getTriggersOfJob(INITIATOR_JOB_NAME, this.getJobGroup());
                boolean foundActiveTrigger = false;
                for (Trigger trigger : triggersOfJob) {
                    int triggerState = this.scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
                    if (triggerState != 0 && triggerState != 4) continue;
                    foundActiveTrigger = true;
                    break;
                }
                if (!foundActiveTrigger) {
                    running = false;
                }
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return running;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    @Override
    public boolean invoke() {
        if (this.stopping) {
            logger.warn((Object)"Attempt to invoke an initiator in a stopped state.");
            return false;
        }
        this.flow.sync();
        List<Event> events = null;
        try {
            events = this.eventProvider.getEvents();
            if (events == null || events.size() == 0) {
                this.resume();
                return false;
            }
        }
        catch (Throwable eventSourcingThrowable) {
            IkasanExceptionAction action = this.exceptionHandler.handleThrowable(this.name, eventSourcingThrowable);
            this.logError(null, eventSourcingThrowable, this.name, action);
            this.handleAction(action, null);
        }
        this.invokeFlow(events);
        return this.allowImmediateReinvocationOnEvent;
    }

    public boolean isAllowImmediateReinvocationOnEvent() {
        return this.allowImmediateReinvocationOnEvent;
    }

    public void setAllowImmediateReinvocationOnEvent(boolean allowImmediateReinvocationOnEvent) {
        this.allowImmediateReinvocationOnEvent = allowImmediateReinvocationOnEvent;
    }

    public String getInitiatorJobName() {
        return INITIATOR_JOB_NAME;
    }
}

