/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.scheduled.quartz;

import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.ikasan.framework.initiator.scheduled.quartz.QuartzDrivenInitiator;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class IkasanJobFactory
implements JobFactory {
    private static Logger logger = Logger.getLogger(IkasanJobFactory.class);
    private QuartzDrivenInitiator initiator;

    public IkasanJobFactory(QuartzDrivenInitiator initiator) {
        this.initiator = initiator;
    }

    public Job newJob(TriggerFiredBundle bundle) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        Class jobClass = jobDetail.getJobClass();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Producing instance of Job '" + jobDetail.getFullName() + "', class=" + jobClass.getName()));
        }
        try {
            Class[] paramTypes = new Class[]{QuartzDrivenInitiator.class};
            Object[] paramArgs = new Object[]{this.initiator};
            Constructor con = jobClass.getConstructor(paramTypes);
            return (Job)con.newInstance(paramArgs);
        }
        catch (Exception e) {
            SchedulerException se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", (Throwable)e);
            throw se;
        }
    }
}

