/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven.jca.jboss;

import javax.jms.Destination;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.event.serialisation.JmsMessageEventSerialiser;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.messagedriven.jca.EventMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.jca.JmsMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.jca.JmsMessageDrivenInitiatorImpl;
import org.ikasan.framework.initiator.messagedriven.jca.MessageListenerContainer;
import org.ikasan.framework.initiator.messagedriven.jca.RawMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.jca.jboss.JBossJmsActivationSpecConfig;
import org.ikasan.framework.initiator.messagedriven.jca.jboss.JBossJmsActivationSpecFactory;
import org.ikasan.framework.initiator.messagedriven.jca.jboss.JBossResourceAdapterUtils;
import org.ikasan.framework.initiator.messagedriven.jca.spring.JmsMessageEndpointManager;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jms.listener.endpoint.JmsActivationSpecFactory;
import org.springframework.jms.support.destination.DestinationResolver;

public class JBossMessageDrivenInitiatorFactoryBean
implements FactoryBean,
BeanNameAware {
    private String name;
    private String moduleName;
    private Destination destination;
    private DestinationResolver destinationResolver;
    private String destinationName;
    private Flow flow;
    private IkasanExceptionHandler exceptionHandler;
    private JmsMessageEventSerialiser eventDeserialiser;
    private PayloadFactory payloadFactory;
    private Class<? extends JmsMessageDrivenInitiatorImpl> objectType;
    private JmsMessageDrivenInitiator initiator;
    private String messageSelector;
    private Integer acknowledgementMode = new Integer(1);
    private Boolean subscriptionDurable = Boolean.TRUE;
    private Boolean pubSubDomain = Boolean.TRUE;
    private Boolean respectPriority = Boolean.FALSE;
    private String providerAdapterJNDI = "java:/DefaultJMSProvider";
    private String username;
    private String password;
    private Integer maxMessages = new Integer(1);
    private Integer maxSession = new Integer(1);
    private Integer keepAlive = new Integer(60000);
    private Integer reconnectInterval = new Integer(10);
    private Boolean deliveryActive = Boolean.FALSE;
    private Boolean useDLQ = Boolean.FALSE;
    private String dlqHandler;
    private String dlqUser;
    private String dlqPassword;
    private String dlqClientId;
    private Boolean forceTransacted = Boolean.FALSE;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public JmsMessageEventSerialiser getEventDeserialiser() {
        return this.eventDeserialiser;
    }

    public void setEventDeserialiser(JmsMessageEventSerialiser eventDeserialiser) {
        this.eventDeserialiser = eventDeserialiser;
    }

    public PayloadFactory getPayloadFactory() {
        return this.payloadFactory;
    }

    public void setPayloadFactory(PayloadFactory payloadFactory) {
        this.payloadFactory = payloadFactory;
    }

    public JmsMessageDrivenInitiator getInitiator() {
        return this.initiator;
    }

    public void setInitiator(JmsMessageDrivenInitiator initiator) {
        this.initiator = initiator;
    }

    public String getProviderAdapterJNDI() {
        return this.providerAdapterJNDI;
    }

    public void setProviderAdapterJNDI(String providerAdapterJNDI) {
        this.providerAdapterJNDI = providerAdapterJNDI;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(Integer maxMessages) {
        this.maxMessages = maxMessages;
    }

    public Integer getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(Integer maxSession) {
        this.maxSession = maxSession;
    }

    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(Integer reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public Boolean getDeliveryActive() {
        return this.deliveryActive;
    }

    public void setDeliveryActive(Boolean deliveryActive) {
        this.deliveryActive = deliveryActive;
    }

    public Boolean getPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(Boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public Boolean getUseDLQ() {
        return this.useDLQ;
    }

    public void setUseDLQ(Boolean useDLQ) {
        this.useDLQ = useDLQ;
    }

    public String getDlqHandler() {
        return this.dlqHandler;
    }

    public void setDlqHandler(String dlqHandler) {
        this.dlqHandler = dlqHandler;
    }

    public String getDlqUser() {
        return this.dlqUser;
    }

    public void setDlqUser(String dlqUser) {
        this.dlqUser = dlqUser;
    }

    public String getDlqPassword() {
        return this.dlqPassword;
    }

    public void setDlqPassword(String dlqPassword) {
        this.dlqPassword = dlqPassword;
    }

    public String getDlqClientId() {
        return this.dlqClientId;
    }

    public void setDlqClientId(String dlqClientId) {
        this.dlqClientId = dlqClientId;
    }

    public Boolean getForceTransacted() {
        return this.forceTransacted;
    }

    public void setForceTransacted(Boolean forceTransacted) {
        this.forceTransacted = forceTransacted;
    }

    public Boolean getRespectPriority() {
        return this.respectPriority;
    }

    public void setRespectPriority(Boolean respectPriority) {
        this.respectPriority = respectPriority;
    }

    public Object getObject() throws Exception {
        if (this.initiator == null) {
            JBossJmsActivationSpecConfig specConfig = this.constructActivationSpec();
            JBossJmsActivationSpecFactory specFactory = new JBossJmsActivationSpecFactory();
            JmsMessageEndpointManager endpointManager = new JmsMessageEndpointManager();
            endpointManager.setActivationSpecFactory((JmsActivationSpecFactory)specFactory);
            endpointManager.setActivationSpecConfig(specConfig);
            endpointManager.setResourceAdapter(JBossResourceAdapterUtils.getResourceAdapter());
            this.initiator = this.constructInitiator(endpointManager);
            endpointManager.setMessageListener(this.initiator);
            endpointManager.setAutoStartup(this.deliveryActive);
            endpointManager.afterPropertiesSet();
        }
        return this.initiator;
    }

    private JBossJmsActivationSpecConfig constructActivationSpec() {
        if (this.destinationName == null && this.destination == null && this.destinationResolver == null) {
            throw new IllegalArgumentException("either destination or destinationResolver is mandatory for JmsMessageDrivenInitiator creation");
        }
        JBossJmsActivationSpecConfig specConfig = new JBossJmsActivationSpecConfig();
        specConfig.setDestinationName(this.destinationName);
        specConfig.setPubSubDomain(this.pubSubDomain);
        specConfig.setSubscriptionDurable(this.subscriptionDurable);
        if (this.subscriptionDurable.booleanValue()) {
            specConfig.setDurableSubscriptionName(this.moduleName + '-' + this.flow.getName() + '-' + this.name);
        }
        specConfig.setMessageSelector(this.messageSelector);
        specConfig.setAcknowledgeMode(this.acknowledgementMode);
        specConfig.setMaxConcurrency(this.maxMessages);
        specConfig.setPrefetchSize(this.maxSession);
        specConfig.setProviderAdapterJNDI(this.providerAdapterJNDI);
        specConfig.setUser(this.username);
        specConfig.setPassword(this.password);
        specConfig.setKeepAlive(this.keepAlive);
        specConfig.setReconnectInterval(this.reconnectInterval);
        specConfig.setUseDLQ(this.useDLQ);
        specConfig.setDlqHandler(this.dlqHandler);
        specConfig.setDlqUser(this.dlqUser);
        specConfig.setDlqPassword(this.dlqPassword);
        specConfig.setDlqClientId(this.dlqClientId);
        specConfig.setForceTransacted(this.forceTransacted);
        return specConfig;
    }

    private JmsMessageDrivenInitiator constructInitiator(MessageListenerContainer messageListenerContainer) {
        if (this.moduleName == null || "".equals(this.moduleName)) {
            throw new IllegalArgumentException("moduleName is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.name == null || "".equals(this.name)) {
            throw new IllegalArgumentException("name is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.flow == null) {
            throw new IllegalArgumentException("flow is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.eventDeserialiser == null && this.payloadFactory == null) {
            throw new IllegalArgumentException("payloadFactory is mandatory for JmsMessageDrivenInitiator creation, if no JmsMessageEventSerialiser has been set");
        }
        if (this.eventDeserialiser != null) {
            EventMessageDrivenInitiator eventMDI = new EventMessageDrivenInitiator(this.moduleName, this.name, this.flow, this.exceptionHandler, this.eventDeserialiser);
            eventMDI.setMessageListenerContainer(messageListenerContainer);
            return eventMDI;
        }
        RawMessageDrivenInitiator rawMDI = new RawMessageDrivenInitiator(this.moduleName, this.name, this.flow, this.exceptionHandler, this.payloadFactory);
        rawMDI.setRespectPriority(this.respectPriority);
        rawMDI.setMessageListenerContainer(messageListenerContainer);
        return rawMDI;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String beanName) {
        if (this.name == null) {
            this.name = beanName;
        }
    }
}

