/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven.jca.jboss;

import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.event.serialisation.JmsMessageEventSerialiser;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.messagedriven.jca.JmsMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.jca.jboss.JBossJmsActivationSpecConfig;
import org.ikasan.framework.initiator.messagedriven.jca.jboss.JBossJmsActivationSpecFactory;
import org.ikasan.framework.initiator.messagedriven.jca.jboss.JBossResourceAdapterUtils;
import org.ikasan.framework.initiator.messagedriven.jca.spring.JmsMessageEndpointManager;
import org.ikasan.framework.initiator.messagedriven.jca.spring.JtaTransactionManager;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jms.listener.endpoint.JmsActivationSpecFactory;

public class JBossJmsEndpointManagerFactoryBean
implements FactoryBean,
BeanNameAware {
    JmsMessageEndpointManager endpointManager;
    private String clientId;
    private String name;
    private String moduleName;
    private String destinationName;
    private Flow flow;
    private JmsMessageEventSerialiser eventDeserialiser;
    private PayloadFactory payloadFactory;
    private Class<? extends JmsMessageEndpointManager> objectType;
    private JmsMessageDrivenInitiator initiator;
    private String messageSelector;
    private Integer acknowledgementMode = new Integer(1);
    private Boolean subscriptionDurable = Boolean.TRUE;
    private Boolean pubSubDomain = Boolean.TRUE;
    private String providerAdapterJNDI = "java:/DefaultJMSProvider";
    private String username;
    private String password;
    private Integer maxMessages = new Integer(1);
    private Integer maxSession = new Integer(1);
    private Integer keepAlive = new Integer(60000);
    private Integer reconnectInterval = new Integer(10);
    private Boolean deliveryActive = Boolean.FALSE;
    private Boolean useDLQ = Boolean.FALSE;
    private String dlqHandler;
    private String dlqUser;
    private String dlqPassword;
    private String dlqClientId;
    private Boolean forceTransacted = Boolean.FALSE;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public JmsMessageEventSerialiser getEventDeserialiser() {
        return this.eventDeserialiser;
    }

    public void setEventDeserialiser(JmsMessageEventSerialiser eventDeserialiser) {
        this.eventDeserialiser = eventDeserialiser;
    }

    public PayloadFactory getPayloadFactory() {
        return this.payloadFactory;
    }

    public void setPayloadFactory(PayloadFactory payloadFactory) {
        this.payloadFactory = payloadFactory;
    }

    public JmsMessageDrivenInitiator getInitiator() {
        return this.initiator;
    }

    public void setInitiator(JmsMessageDrivenInitiator initiator) {
        this.initiator = initiator;
    }

    public String getProviderAdapterJNDI() {
        return this.providerAdapterJNDI;
    }

    public void setProviderAdapterJNDI(String providerAdapterJNDI) {
        this.providerAdapterJNDI = providerAdapterJNDI;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(Integer maxMessages) {
        this.maxMessages = maxMessages;
    }

    public Integer getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(Integer maxSession) {
        this.maxSession = maxSession;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public Boolean getSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(Boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public Boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(Boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(Integer reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public Boolean isDeliveryActive() {
        return this.deliveryActive;
    }

    public void setDeliveryActive(Boolean deliveryActive) {
        this.deliveryActive = deliveryActive;
    }

    public Boolean isUseDLQ() {
        return this.useDLQ;
    }

    public void setUseDLQ(Boolean useDLQ) {
        this.useDLQ = useDLQ;
    }

    public String getDlqHandler() {
        return this.dlqHandler;
    }

    public void setDlqHandler(String dlqHandler) {
        this.dlqHandler = dlqHandler;
    }

    public String getDlqUser() {
        return this.dlqUser;
    }

    public void setDlqUser(String dlqUser) {
        this.dlqUser = dlqUser;
    }

    public String getDlqPassword() {
        return this.dlqPassword;
    }

    public void setDlqPassword(String dlqPassword) {
        this.dlqPassword = dlqPassword;
    }

    public String getDlqClientId() {
        return this.dlqClientId;
    }

    public void setDlqClientId(String dlqClientId) {
        this.dlqClientId = dlqClientId;
    }

    public Boolean isForceTransacted() {
        return this.forceTransacted;
    }

    public void setForceTransacted(Boolean forceTransacted) {
        this.forceTransacted = forceTransacted;
    }

    public Object getObject() throws Exception {
        if (this.endpointManager == null) {
            if (this.initiator == null) {
                throw new IllegalArgumentException("Initiator is a mandatory attribute for JBossJmsEndpointManager creation");
            }
            JBossJmsActivationSpecConfig specConfig = this.constructActivationSpec();
            JBossJmsActivationSpecFactory specFactory = new JBossJmsActivationSpecFactory();
            JtaTransactionManager transactionManager = new JtaTransactionManager();
            transactionManager.afterPropertiesSet();
            this.endpointManager = new JmsMessageEndpointManager();
            this.endpointManager.setActivationSpecFactory((JmsActivationSpecFactory)specFactory);
            this.endpointManager.setActivationSpecConfig(specConfig);
            this.endpointManager.setResourceAdapter(JBossResourceAdapterUtils.getResourceAdapter());
            this.endpointManager.setMessageListener(this.initiator);
            this.endpointManager.setAutoStartup(this.deliveryActive);
            this.endpointManager.setTransactionManager((Object)transactionManager);
            this.endpointManager.afterPropertiesSet();
        }
        return this.endpointManager;
    }

    private JBossJmsActivationSpecConfig constructActivationSpec() {
        if (this.destinationName == null) {
            throw new IllegalArgumentException("DestinationName is a mandatory attribute for JBossJmsActivationSpecConfig within JBossJmsEndpointManager creation");
        }
        if (this.moduleName == null || this.flow == null || this.name == null) {
            throw new IllegalArgumentException("ModuleName[" + this.moduleName + "], flow[" + this.flow + "], and name[" + this.name + "] are all mandatory attributes for JBossJmsActivationSpecConfig within JBossJmsEndpointManager creation");
        }
        JBossJmsActivationSpecConfig specConfig = new JBossJmsActivationSpecConfig();
        specConfig.setDestinationName(this.destinationName);
        specConfig.setPubSubDomain(this.pubSubDomain);
        specConfig.setSubscriptionDurable(this.subscriptionDurable);
        if (this.subscriptionDurable.booleanValue()) {
            specConfig.setDurableSubscriptionName(this.moduleName + '-' + this.flow.getName() + '-' + this.name);
        }
        specConfig.setMessageSelector(this.messageSelector);
        specConfig.setAcknowledgeMode(this.acknowledgementMode);
        specConfig.setMaxConcurrency(this.maxMessages);
        specConfig.setPrefetchSize(this.maxSession);
        specConfig.setProviderAdapterJNDI(this.providerAdapterJNDI);
        specConfig.setClientId(this.clientId);
        specConfig.setUser(this.username);
        specConfig.setPassword(this.password);
        specConfig.setKeepAlive(this.keepAlive);
        specConfig.setReconnectInterval(this.reconnectInterval);
        specConfig.setUseDLQ(this.useDLQ);
        specConfig.setDlqHandler(this.dlqHandler);
        specConfig.setDlqUser(this.dlqUser);
        specConfig.setDlqPassword(this.dlqPassword);
        specConfig.setDlqClientId(this.dlqClientId);
        specConfig.setForceTransacted(this.forceTransacted);
        return specConfig;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String beanName) {
        if (this.name == null) {
            this.name = beanName;
        }
    }
}

